/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.basic;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.basic.A;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBasicTest1() throws Exception {
        this.logTrace("Begin detachBasicTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            this.logTrace("Persist Instance");
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("tx started, see if entity is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                this.logErr("contains method returned true; expected false (detached), test fails.");
                pass = false;
            } else {
                try {
                    this.logTrace("try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("IllegalArgumentException caught as expected", iae);
                    pass = true;
                }
            }
            this.logTrace("tx commit");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logTrace("or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass) {
                if (e instanceof TransactionRolledbackException || e instanceof PersistenceException) {
                    pass = true;
                } else {
                    this.logErr("Not TransactionRolledbackException nor PersistenceException, totally unexpected:", e);
                }
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("detachBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBasicTest2() throws Exception {
        this.logTrace("Begin detachBasicTest2");
        boolean pass = false;
        A expected = new A("1", "a1", 1);
        try {
            this.logTrace("Persist Instance");
            this.createA(new A("1", "a1", 1));
            this.getEntityTransaction().begin();
            this.logTrace("Executing find");
            A newA = (A)this.getEntityManager().find(A.class, (Object)"1");
            this.logTrace("newA:" + newA.toString());
            this.logTrace("changing name");
            newA.setAName("foobar");
            this.logTrace("newA:" + newA.toString());
            this.logTrace("executing detach");
            this.getEntityManager().detach((Object)newA);
            this.logTrace("newA:" + newA.toString());
            this.logTrace("tx commit");
            this.getEntityTransaction().commit();
            A newAA = (A)this.getEntityManager().find(A.class, (Object)"1");
            this.logTrace("newAA:" + newAA.toString());
            if (expected.equals(newAA)) {
                pass = true;
            } else {
                this.logErr("Changes made to entity were persisted even though it was detached without a flush");
                this.logErr("expected A:" + expected.toString() + ", actual A:" + newAA.toString());
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("detachBasicTest2 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

