/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.delete;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Book;
import ee.jakarta.tck.nosql.factories.BookListSupplier;
import java.util.List;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DeleteRecordTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should insert and delete the book")
    void shouldInsertAndDeleteBook(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            this.template.delete(Book.class).where("title").eq((Object)books.get(0).title()).execute();
            List deletedBook = this.template.select(Book.class).where("title").eq((Object)books.get(0).title()).result();
            SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedBook).isEmpty());
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookListSupplier.class)
    @DisplayName(value="Should delete book with complex condition")
    void shouldDeleteBookWithComplexCondition(List<Book> books) {
        books.forEach(book -> this.template.insert(book));
        try {
            this.template.delete(Book.class).where("genre").eq((Object)books.get(0).genre()).and("author").eq((Object)books.get(0).author()).execute();
            List deletedBooks = this.template.select(Book.class).where("genre").eq((Object)books.get(0).genre()).and("author").eq((Object)books.get(0).author()).result();
            SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedBooks).isEmpty());
        }
        catch (UnsupportedOperationException exp) {
            SoftAssertions.assertSoftly(soft -> soft.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class));
        }
    }
}

