/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.diagram;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.glsp.graph.GraphExtension;
import org.eclipse.glsp.server.layout.ServerLayoutKind;
import org.eclipse.glsp.server.types.EdgeTypeHint;
import org.eclipse.glsp.server.types.ShapeTypeHint;

public interface DiagramConfiguration {
    public String getDiagramType();

    public Map<String, EClass> getTypeMappings();

    public List<ShapeTypeHint> getShapeTypeHints();

    public List<EdgeTypeHint> getEdgeTypeHints();

    public Optional<GraphExtension> getGraphExtension();

    default public EdgeTypeHint createDefaultEdgeTypeHint(String elementId) {
        return new EdgeTypeHint(elementId, true, true, true, false, null, null);
    }

    default public ShapeTypeHint createDefaultShapeTypeHint(String elementId) {
        return new ShapeTypeHint(elementId, true, true, true, false);
    }

    default public ServerLayoutKind getLayoutKind() {
        return ServerLayoutKind.NONE;
    }

    default public boolean needsClientLayout() {
        return true;
    }

    default public boolean animatedUpdate() {
        return true;
    }
}

