/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class CifToolPostCheckEnv
extends CifPostCheckEnv {
    private final String absCifDirPath;
    private final String specDescription;
    public Set<String> errors = Sets.set();

    public CifToolPostCheckEnv(String absCifDirPath, String specDescription) {
        this.absCifDirPath = absCifDirPath;
        this.specDescription = specDescription;
    }

    @Override
    public void addProblem(ErrMsg message, Position position, String ... args) {
        String formattedMsg = message.format(args);
        if (message.getSeverity() == SemanticProblemSeverity.ERROR) {
            this.errors.add(formattedMsg);
        }
    }

    @Override
    public String resolveImport(String path) {
        return PlatformUriUtils.resolve((String)path, (String)this.absCifDirPath);
    }

    @Override
    public String getFileReportPath(String absTargetPath, Position position) {
        return PlatformUriUtils.getRelativePath((String)absTargetPath, (String)this.absCifDirPath);
    }

    public void throwUnsupportedExceptionIfAnyErrors(String operationFailedMessage) {
        if (this.errors.isEmpty()) {
            return;
        }
        String reasons = Sets.sortedstrings(this.errors).stream().map(m -> " - " + m).collect(Collectors.joining("\n"));
        String message = Strings.fmt((String)"The %s CIF specification is invalid:\n%s", (Object[])new Object[]{this.specDescription, reasons});
        if (operationFailedMessage == null) {
            throw new UnsupportedException(message);
        }
        throw new UnsupportedException(operationFailedMessage, (Throwable)new UnsupportedException(message));
    }
}

