/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.java.JavaDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class JavaArrayTypeInfo
extends ArrayTypeInfo {
    public JavaArrayTypeInfo(CifType cifType, TypeInfo[] childTIs, int length) {
        super(cifType, childTIs, -1);
    }

    @Override
    public String getElementTargetType() {
        return this.childInfos[0].getTargetType();
    }

    @Override
    public String getTargetType() {
        return Strings.fmt((String)"List<%s>", (Object[])new Object[]{this.getElementTargetType()});
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "equalObjs(${left-value}, ${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "!equalObjs(${left-value}, ${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode convertLiteral(ListExpression expr, Destination dest, CodeContext ctxt) {
        int size = expr.getElements().size();
        String emptyList = Strings.fmt((String)"new ArrayList<%s>(%d)", (Object[])new Object[]{this.getElementTargetType(), size});
        if (size == 0) {
            ExprCode result = new ExprCode();
            result.setDestination(dest);
            result.setDataValue(new JavaDataValue(emptyList));
            return result;
        }
        ExprCode result = new ExprCode();
        StringBuilder listMaker = new StringBuilder();
        listMaker.append("makelist(");
        listMaker.append(emptyList);
        for (Expression elm : expr.getElements()) {
            listMaker.append(", ");
            ExprCode elmCode = ctxt.exprToTarget(elm, null);
            result.add(elmCode);
            listMaker.append(elmCode.getData());
        }
        listMaker.append(')');
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(listMaker.toString()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaArrayTypeInfo)) {
            return false;
        }
        JavaArrayTypeInfo otherArray = (JavaArrayTypeInfo)other;
        return this.childInfos[0].equals(otherArray.childInfos[0]);
    }

    @Override
    public int hashCode() {
        int h = JavaArrayTypeInfo.class.hashCode();
        return h += this.childInfos[0].hashCode();
    }

    @Override
    public ExprCode convertSizeStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(expr, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        String value = "size(" + childCode.getData() + ")";
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(value));
        return result;
    }

    @Override
    public ExprCode convertEmptyStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(expr, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        String value = "empty(" + childCode.getData() + ")";
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(value));
        return result;
    }

    @Override
    public ExprCode getProjectedValue(ExprCode childCode, ExprCode indexCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.add(indexCode);
        String resultText = Strings.fmt((String)"project(%s, %s)", (Object[])new Object[]{childCode.getData(), indexCode.getData()});
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(resultText));
        return result;
    }

    @Override
    public CodeBox modifyContainer(VariableInformation containerVar, ExprCode partCode, ExprCode indexCode, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(indexCode);
        result.add(partCode);
        String resultText = Strings.fmt((String)"modify(%s, %s, %s)", (Object[])new Object[]{containerVar.targetRef, indexCode.getData(), partCode.getData()});
        result.setDestination(ctxt.makeDestination(containerVar));
        result.setDataValue(new JavaDataValue(resultText));
        return result.getCode();
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        ListType lhsList = (ListType)lhsType;
        ListType rhsList = (ListType)rhsType;
        if (CifTypeUtils.checkTypeCompat((CifType)lhsList.getElementType(), (CifType)rhsList.getElementType(), (RangeCompat)RangeCompat.CONTAINED)) {
            return;
        }
        String indexName = Strings.fmt((String)"rng_index%d", (Object[])new Object[]{level});
        String elemName = Strings.fmt((String)"rng_elem%d", (Object[])new Object[]{level});
        code.add("for (int %s = 0; %s < %s.size(); %s++) {", new Object[]{indexName, indexName, rhsValue.getData(), indexName});
        code.indent();
        code.add("%s %s = %s.get(%s);", new Object[]{this.childInfos[0].getTargetType(), elemName, rhsValue.getData(), indexName});
        int last = errorTexts.size();
        errorTexts.add(new RangeCheckErrorLevelText(true, indexName));
        this.childInfos[0].checkRange(lhsList.getElementType(), rhsList.getElementType(), new JavaDataValue(elemName), varType, varName, errorTexts, level + 1, code, ctxt);
        errorTexts.remove(last);
        Assert.check((last == errorTexts.size() ? 1 : 0) != 0);
        code.dedent();
        code.add("}");
    }
}

