//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.eventbased.equivalence;

import static org.eclipse.escet.common.java.Strings.fmt;

import org.eclipse.escet.cif.eventbased.automata.Location;

/** Location in a block. */
public class BlockLocation {
    /** Represented location. */
    public final Location loc;

    /** Index number of the automaton of the location. */
    public final int autIdx;

    /** Path length of the location from the initial state. */
    public final int depth;

    /** Index number of the block that it is part of. */
    public int blockNumber;

    /**
     * Constructor of the {@link BlockLocation} class.
     *
     * @param loc Represented location.
     * @param autIdx Index number of the automaton of the location.
     * @param depth Path length of the location from the initial state.
     * @param blockNumber Index number of the block that it is part of.
     */
    public BlockLocation(Location loc, int autIdx, int depth, int blockNumber) {
        this.loc = loc;
        this.autIdx = autIdx;
        this.depth = depth;
        this.blockNumber = blockNumber;
    }

    @Override
    public String toString() {
        return fmt("BlockLocation(loc=%s, aut=%d, depth=%d, block=%d)", loc, autIdx, depth, blockNumber);
    }
}
