/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.output;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.ErrorOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class OutputProvider<T extends IOutputComponent> {
    protected OutputMode mode = OutputModeOption.DEFAULT_VALUE;
    protected final List<T> components = new CopyOnWriteArrayList<T>();
    protected int dbgLevel = 0;
    protected int outLevel = 0;
    protected int warningCount = 0;
    private DebugNormalOutput debugOutput;
    private DebugNormalOutput normalOutput;
    private WarnOutput warnOutput;
    private ErrorOutput errorOutput;

    public synchronized DebugNormalOutput getDebugOutputStream() {
        if (this.debugOutput == null) {
            this.debugOutput = new DebugNormalOutput(){

                public void line(String message) {
                    OutputProvider.this.dbgInternal(message);
                }

                public boolean isEnabled() {
                    return OutputProvider.this.dodbgInternal();
                }

                public void inc() {
                    OutputProvider.this.idbgInternal();
                }

                public void dec() {
                    OutputProvider.this.ddbgInternal();
                }
            };
        }
        return this.debugOutput;
    }

    public synchronized DebugNormalOutput getNormalOutputStream() {
        if (this.normalOutput == null) {
            this.normalOutput = new DebugNormalOutput(){

                public void line(String message) {
                    OutputProvider.this.outInternal(message);
                }

                public boolean isEnabled() {
                    return OutputProvider.this.dooutInternal();
                }

                public void inc() {
                    OutputProvider.this.ioutInternal();
                }

                public void dec() {
                    OutputProvider.this.doutInternal();
                }
            };
        }
        return this.normalOutput;
    }

    public synchronized WarnOutput getWarningOutputStream() {
        if (this.warnOutput == null) {
            this.warnOutput = new WarnOutput(){

                public void line(String message) {
                    OutputProvider.this.warnInternal(message);
                }

                public boolean isEnabled() {
                    return OutputProvider.this.dowarnInternal();
                }
            };
        }
        return this.warnOutput;
    }

    public synchronized ErrorOutput getErrorOutputStream() {
        if (this.errorOutput == null) {
            this.errorOutput = new ErrorOutput(){

                public void line(String message) {
                    OutputProvider.this.errInternal(message);
                }
            };
        }
        return this.errorOutput;
    }

    public void setOutputMode(OutputMode mode) {
        this.mode = mode;
    }

    protected int getComponentCountInternal() {
        return this.components.size();
    }

    public static int getComponentCount() {
        return AppEnv.getProvider().getComponentCountInternal();
    }

    protected void registerInternal(T component, boolean append) {
        if (this.components.contains(component)) {
            throw new IllegalArgumentException("Output component already registered.");
        }
        if (append) {
            this.components.add(component);
        } else {
            this.components.add(0, component);
        }
        component.initialize();
    }

    public static void register(IOutputComponent component) {
        OutputProvider.register(component, true);
    }

    public static void register(IOutputComponent component, boolean append) {
        AppEnv.getProvider().registerInternal(component, append);
    }

    protected void unregisterInternal(T component) {
        boolean removed = this.components.remove(component);
        if (!removed) {
            throw new IllegalArgumentException("Output component not registered.");
        }
        component.cleanup();
    }

    public static void unregister(IOutputComponent component) {
        AppEnv.getProvider().unregisterInternal(component);
    }

    protected void resetLevelsInternal() {
        this.dbgLevel = 0;
        this.outLevel = 0;
    }

    public static void resetLevels() {
        AppEnv.getProvider().resetLevelsInternal();
    }

    protected int getDbgLevelInternal() {
        return this.dbgLevel;
    }

    public static int getDbgLevel() {
        return AppEnv.getProvider().getDbgLevelInternal();
    }

    protected int getOutLevelInternal() {
        return this.outLevel;
    }

    public static int getOutLevel() {
        return AppEnv.getProvider().getOutLevelInternal();
    }

    protected void resetWarningCountInternal() {
        this.warningCount = 0;
    }

    public static void resetWarningCount() {
        AppEnv.getProvider().resetWarningCountInternal();
    }

    protected int getWarningCountInternal() {
        return this.warningCount;
    }

    public static int getWarningCount() {
        return AppEnv.getProvider().getWarningCountInternal();
    }

    public static boolean dodbg() {
        return AppEnv.getProvider().dodbgInternal();
    }

    protected boolean dodbgInternal() {
        return this.mode == OutputMode.DEBUG;
    }

    protected void idbgInternal() {
        if (this.dodbgInternal()) {
            ++this.dbgLevel;
        }
    }

    public static void idbg() {
        AppEnv.getProvider().idbgInternal();
    }

    protected void ddbgInternal() {
        if (this.dodbgInternal()) {
            Assert.check((this.dbgLevel > 0 ? 1 : 0) != 0);
            --this.dbgLevel;
        }
    }

    public static void ddbg() {
        AppEnv.getProvider().ddbgInternal();
    }

    protected void dbgInternal(String msg) {
        if (!this.dodbgInternal()) {
            return;
        }
        for (IOutputComponent component : this.components) {
            component.dbg(msg, this.dbgLevel + this.outLevel);
        }
    }

    public static void dbg(String msg) {
        AppEnv.getProvider().dbgInternal(msg);
    }

    public static void dbg(String msg, Object ... args) {
        OutputProvider.dbg(Strings.fmt((String)msg, (Object[])args));
    }

    public static void dbg() {
        OutputProvider.dbg("");
    }

    public static boolean doout() {
        return AppEnv.getProvider().dooutInternal();
    }

    protected boolean dooutInternal() {
        return this.mode == OutputMode.NORMAL || this.mode == OutputMode.DEBUG;
    }

    protected void ioutInternal() {
        if (this.dooutInternal()) {
            ++this.outLevel;
        }
    }

    public static void iout() {
        AppEnv.getProvider().ioutInternal();
    }

    protected void doutInternal() {
        if (this.dooutInternal()) {
            Assert.check((this.outLevel > 0 ? 1 : 0) != 0);
            --this.outLevel;
        }
    }

    public static void dout() {
        AppEnv.getProvider().doutInternal();
    }

    protected void outInternal(String msg) {
        if (!this.dooutInternal()) {
            return;
        }
        for (IOutputComponent component : this.components) {
            component.out(msg, this.dbgLevel + this.outLevel);
        }
    }

    public static void out(String msg) {
        AppEnv.getProvider().outInternal(msg);
    }

    public static void out(String msg, Object ... args) {
        OutputProvider.out(Strings.fmt((String)msg, (Object[])args));
    }

    public static void out() {
        OutputProvider.out("");
    }

    public static void outw(String msg, Object ... args) {
        String[] stringArray = Strings.wrap((String[])new String[]{Strings.fmt((String)msg, (Object[])args)});
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String txt = stringArray[n2];
            OutputProvider.out(txt);
            ++n2;
        }
    }

    public static boolean dowarn() {
        return AppEnv.getProvider().dowarnInternal();
    }

    protected boolean dowarnInternal() {
        return this.mode != OutputMode.ERROR;
    }

    protected void warnInternal(String msg) {
        if (!this.dowarnInternal()) {
            return;
        }
        ++this.warningCount;
        for (IOutputComponent component : this.components) {
            component.warn(msg, this.dbgLevel + this.outLevel);
        }
    }

    public static void warn(String msg) {
        AppEnv.getProvider().warnInternal(msg);
    }

    public static void warn(String msg, Object ... args) {
        OutputProvider.warn(Strings.fmt((String)msg, (Object[])args));
    }

    public static void warn() {
        OutputProvider.warn("");
    }

    protected void errInternal(String msg) {
        for (IOutputComponent component : this.components) {
            component.err(msg);
        }
    }

    public static void err(String msg) {
        AppEnv.getProvider().errInternal(msg);
    }

    public static void err(String msg, Object ... args) {
        OutputProvider.err(Strings.fmt((String)msg, (Object[])args));
    }

    protected void cleanupInternal() {
        for (IOutputComponent component : Lists.reverse(this.components)) {
            component.cleanup();
        }
    }

    public static void cleanup() {
        AppEnv.getProvider().cleanupInternal();
    }
}

