/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.ScopeCache;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public final class ConvertEventsControllability {
    private ConvertEventsControllability() {
    }

    public static void convert(Specification spec, boolean toControllable) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String eventSource = toControllable ? "uncontrollable" : "controllable";
            String eventDestination = toControllable ? "controllable" : "uncontrollable";
            String msg = Strings.fmt((String)"Converting %s events to %s events", (Object[])new Object[]{eventSource, eventDestination});
            throw new CifToCifPreconditionException(msg + " in a CIF specification with component definitions is currently not supported.");
        }
        List events = Lists.list();
        CifCollectUtils.collectEvents((ComplexComponent)spec, (Collection)events);
        String prefixToReplace = toControllable ? "u_" : "c_";
        String prefixReplacement = toControllable ? "c_" : "u_";
        ScopeCache scopeCache = new ScopeCache();
        for (Event event : events) {
            if (event.getControllable() == null || event.getControllable() == toControllable) continue;
            event.setControllable(Boolean.valueOf(toControllable));
            String name = event.getName();
            Set localNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)CifScopeUtils.getScope((PositionObject)event), (ScopeCache)scopeCache);
            if (!name.startsWith(prefixToReplace)) continue;
            Object newName = prefixReplacement + name.substring(prefixToReplace.length());
            if (localNames.contains(newName)) {
                newName = CifScopeUtils.getUniqueName((String)newName, (Set)localNames, Collections.emptySet());
            }
            event.setName((String)newName);
            localNames.remove(name);
            localNames.add(newName);
        }
        CifControllerPropertiesAnnotationUtils.remove((Specification)spec);
    }

    public static class ConvertCntrlEventsToUncntrl
    implements CifToCifTransformation {
        @Override
        public void transform(Specification spec) {
            ConvertEventsControllability.convert(spec, false);
        }
    }

    public static class ConvertUncntrlEventsToCntrl
    implements CifToCifTransformation {
        @Override
        public void transform(Specification spec) {
            ConvertEventsControllability.convert(spec, true);
        }
    }
}

