/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.util.ParserUtils;
import org.htmlunit.cssparser.util.ThrowCssExceptionErrorHandler;
import org.w3c.dom.DOMException;

public class CSSPageRuleImpl
extends AbstractCSSRuleImpl {
    private String pseudoPage_;
    private CSSStyleDeclarationImpl style_;

    public CSSPageRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, String pseudoPage) {
        super(parentStyleSheet, parentRule);
        this.pseudoPage_ = pseudoPage;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        String sel = this.getSelectorText();
        sb.append("@page ").append(sel);
        if (sel.length() > 0) {
            sb.append(' ');
        }
        sb.append("{ ");
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null != style) {
            sb.append(style.getCssText());
            if (style.getProperties().size() > 0) {
                sb.append("; ");
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSPageRuleImpl)) {
                throw new DOMExceptionImpl(13, 8);
            }
            this.pseudoPage_ = ((CSSPageRuleImpl)r).pseudoPage_;
            this.style_ = ((CSSPageRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        if (null == this.pseudoPage_) {
            return "";
        }
        return this.pseudoPage_;
    }

    public void setSelectorText(String selectorText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            AbstractCSSRuleImpl r = parser.parseRule("@page " + selectorText + " {}");
            if (!(r instanceof CSSPageRuleImpl)) {
                throw new DOMExceptionImpl(13, 8);
            }
            this.pseudoPage_ = ((CSSPageRuleImpl)r).pseudoPage_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSPageRuleImpl)) {
            return false;
        }
        CSSPageRuleImpl cpr = (CSSPageRuleImpl)obj;
        return super.equals(obj) && ParserUtils.equals(this.getSelectorText(), cpr.getSelectorText()) && ParserUtils.equals(this.getStyle(), cpr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.pseudoPage_);
        hash = ParserUtils.hashCode(hash, this.style_);
        return hash;
    }

    public String toString() {
        return this.getCssText();
    }
}

