package org.eclipse.fx.ide.fxml.command

import org.eclipse.fx.ide.fxml.command.GenerateController.ControllerJDTElement
import org.eclipse.fx.ide.model.IFXClass
import java.util.HashSet
import org.eclipse.fx.ide.model.IFXEventHandlerProperty
import java.util.Map
import java.util.HashMap

class ControllerGenerator {
	ControllerJDTElement d;
	Map<String,String> abbrev = new HashMap

	new(ControllerJDTElement d) {
		this.d = d;
	}

	def generate() '''
	package «d.packageFragment.elementName»;

	import javafx.fxml.FXML;
	«FOR e : d.entries.fold(new HashSet,[s,e|
		var String fqn;
		var String simple;

		if( e.type instanceof IFXClass ) {
			fqn = (e.type as IFXClass).FQN
			simple = (e.type as IFXClass).simpleName
		} else {
			fqn = (e.type as IFXEventHandlerProperty).getEventTypeAsString(true)
			simple = (e.type as IFXEventHandlerProperty).getEventTypeAsString(false)
		}

		if( ! abbrev.containsKey(fqn) ) {
			if( ! abbrev.containsValue(simple) ) {
				s.add(fqn)
			}

			abbrev.put(fqn,simple)
		}


		return s
	])»

	import «e»;
	«ENDFOR»

	public class «d.name» {
		«FOR f : d.entries.filter[e|e.type instanceof IFXClass]»
		@FXML
		private «abbrev.get((f.type as IFXClass).FQN)» «f.name»;
		«ENDFOR»

		«FOR f : d.entries.filter[e|e.type instanceof IFXEventHandlerProperty]»
		«IF f.ownerId != null»
		// Event Listener on «f.owner.simpleName»[#«f.ownerId»].«(f.type as IFXEventHandlerProperty).name»
		«ELSE»
		// Event Listener on «f.owner.simpleName».«(f.type as IFXEventHandlerProperty).name»
		«ENDIF»
		@FXML
		public void «f.name.substring(1)»(«abbrev.get((f.type as IFXEventHandlerProperty).getEventTypeAsString(true))» event) {
			// TODO Autogenerated
		}
		«ENDFOR»
	}
	'''
}