/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.services;

import org.eclipse.fx.code.editor.StringInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;

public class StringInputAboutToChange {
    private final DocumentEvent event;
    private final StringInput input;

    public StringInputAboutToChange(StringInput input, DocumentEvent event) {
        this.event = event;
        this.input = input;
    }

    public StringInput input() {
        return this.input;
    }

    public int offset() {
        return this.event.getOffset();
    }

    public int length() {
        return this.event.getLength();
    }

    public String text() {
        return this.event.getText();
    }

    public int startLine() {
        try {
            return this.event.fDocument.getLineOfOffset(this.offset());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public int startOffsetInLine() {
        try {
            return this.offset() - this.event.fDocument.getLineOffset(this.startLine());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public int endLine() {
        try {
            return this.event.fDocument.getLineOfOffset(this.offset() + this.length());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public int endOffsetInLine() {
        try {
            return this.offset() + this.length() - this.event.fDocument.getLineOffset(this.endLine());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "PreStringInputChangeData [input()=" + String.valueOf(this.input()) + ", offset()=" + this.offset() + ", length()=" + this.length() + ", text()=" + this.text() + ", startLine()=" + this.startLine() + ", startOffsetInLine()=" + this.startOffsetInLine() + ", endLine()=" + this.endLine() + ", endOffsetInLine()=" + this.endOffsetInLine() + "]";
    }
}

