/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.asciidoc.fx.e4;

import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.code.editor.asciidoc.HTMLConverter;
import org.eclipse.fx.code.editor.fx.e4.EditorClassURLProvider;
import org.eclipse.fx.code.editor.fx.e4.EditorContainerService;
import org.eclipse.fx.code.editor.services.EditorOpener;
import org.eclipse.fx.code.editor.services.EditorOpenerTypeProvider;
import org.eclipse.fx.code.editor.services.FileIconProvider;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.di.Service;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=1"})
public class AsciiDoctorEditorOpenerTypeProvider
implements EditorOpenerTypeProvider {
    public Class<? extends EditorOpener> getType(String s) {
        return AsciiDocEditorOpener.class;
    }

    public boolean test(String t) {
        return t.endsWith(".adoc");
    }

    static class AsciiDocEditorOpener
    implements EditorOpener {
        @Inject
        EditorContainerService containerService;
        @Inject
        MApplication application;
        @Inject
        EModelService modelService;
        @Inject
        @Service
        List<FileIconProvider> fileIconProvider;
        @Inject
        @Optional
        HTMLConverter converter;
        @Inject
        @Service
        List<EditorClassURLProvider> editorUrlProvider;

        AsciiDocEditorOpener() {
        }

        public boolean test(String uri) {
            return this.converter != null;
        }

        public boolean openEditor(String uri) {
            IEclipseContext context;
            if (this.converter == null) {
                return false;
            }
            List list = this.modelService.findElements((MApplicationElement)this.application, MCompositePart.class, 29, p -> uri.equals(p.getPersistedState().get("documentUrl")));
            MCompositePart part = null;
            if (list.isEmpty()) {
                MElementContainer container = this.containerService.getContainer();
                if (container != null) {
                    part = (MCompositePart)this.modelService.createModelElement(MCompositePart.class);
                    part.setHorizontal(true);
                    part.getPersistedState().put("documentUrl", uri);
                    part.getTags().add("removeOnHide");
                    part.setCloseable(true);
                    String iconUri = this.fileIconProvider.stream().filter(f -> f.test((Object)uri)).findFirst().map(f -> f.getFileIconUri(uri)).orElse("platform:/plugin/org.eclipse.fx.code.editor.fx.e4/icons/file_16.png");
                    part.setIconURI(iconUri);
                    part.setContributionURI("bundleclass://org.eclipse.fx.code.editor.asciidoc.fx.e4/org.eclipse.fx.code.editor.asciidoc.fx.e4.EditorDelegate");
                    part.setLabel(URI.create((String)uri).lastSegment());
                    MPart textEditor = (MPart)this.modelService.createModelElement(MPart.class);
                    String editorBundleURI = this.editorUrlProvider.stream().filter(e -> e.test((Object)uri)).findFirst().map(e -> e.getBundleClassURI(uri)).orElse("bundleclass://org.eclipse.fx.code.editor.fx/org.eclipse.fx.code.editor.fx.TextEditor");
                    textEditor.setContributionURI(editorBundleURI);
                    part.getChildren().add(textEditor);
                    MPart preview = (MPart)this.modelService.createModelElement(MPart.class);
                    preview.setContributionURI("bundleclass://org.eclipse.fx.code.editor.asciidoc.fx/org.eclipse.fx.code.editor.asciidoc.fx.AsciiDoctorPreviewer");
                    part.getChildren().add(preview);
                    container.getChildren().add(part);
                }
            } else {
                part = (MCompositePart)list.get(0);
            }
            if ((context = this.modelService.getContainingContext((MUIElement)part)) != null) {
                EPartService partService = (EPartService)context.get(EPartService.class);
                partService.activate((MPart)part);
            }
            return true;
        }
    }
}

