/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TransactionListLoader {
    static Logger logger = Globals.getLogger();
    static boolean loaded = false;

    public static void loadTransactions(PartitionedStore store, TransactionList transactionList) throws BrokerException, IOException {
        logger.log(8, "B1136");
        TransactionListLoader.loadLocalTransactions(store, transactionList);
        TransactionListLoader.loadClusterTransactions(store, transactionList);
        TransactionListLoader.loadRemoteTransactions(store, transactionList);
    }

    public static void rollbackAllTransactions(PartitionedStore store) {
        logger.log(8, "rolling back all transactions");
        ((TxnLoggingStore)((Object)store)).rollbackAllTransactions();
    }

    private static void loadDestinations(PartitionedStore store) throws BrokerException {
        if (!loaded) {
            loaded = true;
            Globals.getDestinationList();
            DestinationList.loadDestinations(store);
            Globals.getDestinationList();
            Iterator[] itrs = DestinationList.getAllDestinations(store);
            Iterator itr = itrs[0];
            while (itr.hasNext()) {
                Destination d = (Destination)itr.next();
                d.load();
            }
        }
    }

    private static void loadLocalTransactions(PartitionedStore store, TransactionList transactionList) throws BrokerException {
        List<BaseTransaction> incompleteTxns = ((TxnLoggingStore)((Object)store)).getIncompleteTransactions(1);
        String msg = " loading " + incompleteTxns.size() + " incomplete Local transactions:  ";
        logger.log(4, msg);
        for (BaseTransaction baseTxn : incompleteTxns) {
            TransactionUID tid = baseTxn.getTid();
            msg = " loadTransactions: processing local transaction " + String.valueOf(tid);
            logger.log(4, msg);
            TransactionState state = baseTxn.getTransactionState();
            transactionList.addTransactionID(tid, state, false);
            TransactionWork txnWork = baseTxn.getTransactionWork();
            TransactionListLoader.handleTransactionWork(transactionList, tid, txnWork);
            if (state.getState() != 5 || !state.getOnephasePrepare()) continue;
            transactionList.addDetachedTransactionID(tid);
        }
    }

    private static void loadClusterTransactions(PartitionedStore store, TransactionList transactionList) throws BrokerException, IOException {
        List<BaseTransaction> incompleteTxns = ((TxnLoggingStore)((Object)store)).getIncompleteTransactions(3);
        String msg = " loading " + incompleteTxns.size() + " incomplete cluster transactions:  ";
        if (TransactionList.DEBUG_CLUSTER_TXN) {
            logger.log(8, msg);
        }
        for (ClusterTransaction clusterTransaction : incompleteTxns) {
            TransactionUID tid = clusterTransaction.getTid();
            msg = " loadTransactions: processing cluster transaction " + String.valueOf(tid);
            logger.log(4, msg);
            TransactionState state = clusterTransaction.getTransactionState();
            transactionList.addTransactionID(tid, state, false);
            TransactionBroker[] transactionBrokers = clusterTransaction.getTransactionBrokers();
            transactionList.logClusterTransaction(tid, state, transactionBrokers, true, false);
            TransactionWork txnWork = clusterTransaction.getTransactionWork();
            if (state.getState() == 5) {
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    logger.log(8, "Loading cluster transaction " + String.valueOf(tid) + "[" + String.valueOf(state) + "]");
                }
                TransactionListLoader.handleTransactionWork(transactionList, tid, txnWork);
                if (!state.getOnephasePrepare()) continue;
                transactionList.addDetachedTransactionID(tid);
                continue;
            }
            if (state.getState() != 6) continue;
            transactionList.removeTransaction(tid, false);
        }
    }

    private static void loadRemoteTransactions(PartitionedStore store, TransactionList transactionList) throws BrokerException, IOException {
        List<BaseTransaction> incompleteTxns = ((TxnLoggingStore)((Object)store)).getIncompleteTransactions(2);
        String msg = " loading " + incompleteTxns.size() + " incomplete remote transactions:  ";
        logger.log(4, msg);
        for (RemoteTransaction remoteTransaction : incompleteTxns) {
            TransactionUID tid = remoteTransaction.getTid();
            TransactionState state = remoteTransaction.getTransactionState();
            TransactionAcknowledgement[] tas = remoteTransaction.getTxnAcks();
            DestinationUID[] destIds = remoteTransaction.getDestIds();
            msg = " loadTransactions: processing remote transaction " + String.valueOf(tid) + " state= " + String.valueOf(state);
            logger.log(4, msg);
            BrokerAddress remoteTransactionHomeBroker = remoteTransaction.getTxnHomeBroker();
            transactionList.logRemoteTransaction(tid, state, tas, remoteTransactionHomeBroker, true, true, false);
            for (int i = 0; i < tas.length; ++i) {
                TransactionAcknowledgement ta = tas[i];
                DestinationUID destId = destIds[i];
                TransactionListLoader.unrouteLoadedTransactionAckMessage(store, destId, ta.getSysMessageID(), ta.getStoredConsumerUID());
            }
        }
    }

    static void handleTransactionWork(TransactionList transactionList, TransactionUID tid, TransactionWork txnWork) throws BrokerException {
        TransactionListLoader.handleSentMessages(transactionList, txnWork);
        TransactionListLoader.handleMessageAcks(transactionList, tid, txnWork);
    }

    static void handleSentMessages(TransactionList transactionList, TransactionWork txnWork) throws BrokerException {
        for (int i = 0; i < txnWork.numSentMessages(); ++i) {
            TransactionWorkMessage msg = txnWork.getSentMessages().get(i);
            Packet packet = msg.getMessage();
            DestinationUID duid = msg.getDestUID();
            logger.log(4, " handleSentMessages: duid= " + String.valueOf(duid));
            PacketReference pr = PacketReference.createReference(transactionList.getPartitionedStore(), packet, duid, null);
            Globals.getDestinationList();
            Destination[] ds = DestinationList.getDestination(transactionList.getPartitionedStore(), duid);
            Destination d = ds[0];
            if (d == null) {
                try {
                    int type = duid.isQueue() ? 1 : 2;
                    Globals.getDestinationList();
                    ds = DestinationList.getDestination(transactionList.getPartitionedStore(), duid.getName(), type, true, true);
                    d = ds[0];
                }
                catch (IOException e) {
                    throw new BrokerException("Could not recreate destination " + String.valueOf(duid), e);
                }
            }
            d.load();
            logger.log(4, " loadTransactions: processing prepared sent message " + packet.getMessageID());
            d.queueMessage(pr, true);
            transactionList.addMessage(pr.getTransactionID(), pr.getSysMessageID(), true);
        }
    }

    static void handleMessageAcks(TransactionList transactionList, TransactionUID tid, TransactionWork txnWork) throws BrokerException {
        for (int i = 0; i < txnWork.numMessageAcknowledgments(); ++i) {
            TransactionWorkMessageAck msgAck = txnWork.getMessageAcknowledgments().get(i);
            DestinationUID destID = msgAck.getDestUID();
            TransactionListLoader.handleAck(transactionList, tid, destID, msgAck.getSysMessageID(), msgAck.getConsumerID());
        }
    }

    static void handleAck(TransactionList transactionList, TransactionUID tid, DestinationUID destID, SysMessageID ackedSysMsgID, ConsumerUID consumerID) throws BrokerException {
        logger.log(4, " loadTransactions: processing prepared acknowledged message " + String.valueOf(ackedSysMsgID));
        transactionList.addAcknowledgement(tid, ackedSysMsgID, consumerID, consumerID, true, false);
        transactionList.addOrphanAck(tid, ackedSysMsgID, consumerID, consumerID);
        TransactionListLoader.unrouteLoadedTransactionAckMessage(transactionList.getPartitionedStore(), destID, ackedSysMsgID, consumerID);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void unrouteLoadedTransactionAckMessage(PartitionedStore store, DestinationUID destID, SysMessageID ackedSysMsgID, ConsumerUID consumerID) throws BrokerException {
        logger.log(4, " trying to unroute prepared acknowledged message: destID =  " + String.valueOf(destID) + " ackedMsgId=" + String.valueOf(ackedSysMsgID));
        Destination dest = null;
        PacketReference ackedMessage = null;
        if (destID != null) {
            Globals.getDestinationList();
            Destination[] ds = DestinationList.getDestination(store, destID);
            dest = ds[0];
            if (dest == null) {
                String msg = "Could not find destination for " + String.valueOf(destID);
                logger.log(16, msg);
                return;
            }
            dest.load();
            ackedMessage = dest.getMessage(ackedSysMsgID);
            if (ackedMessage == null) {
                String msg = "Could not find packet for " + String.valueOf(ackedSysMsgID) + "in dest " + String.valueOf(dest);
                logger.log(16, msg);
                return;
            }
        } else {
            logger.log(16, "No dest ID for acked message. Will need to load all dests " + String.valueOf(ackedSysMsgID));
            TransactionListLoader.loadDestinations(store);
            Globals.getDestinationList();
            ackedMessage = DestinationList.get(store, ackedSysMsgID);
            dest = ackedMessage.getDestination();
        }
        dest.unrouteLoadedTransactionAckMessage(ackedMessage, consumerID);
    }
}

