/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private static final System.Logger LOG = System.getLogger(XAResourceWrapper.class.getName());
    private final XAResource resource;

    public XAResourceWrapper(XAResource resource) {
        this.resource = Objects.requireNonNull(resource, "resource");
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "commit: " + XAResourceWrapper.xidToString(xid) + ", onePhase=" + onePhase);
        this.resource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "end: " + XAResourceWrapper.xidToString(xid) + ", flags=" + XAResourceWrapper.flagToString(flags));
        this.resource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "forget: " + XAResourceWrapper.xidToString(xid));
        this.resource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.resource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)xares;
            return this.resource.isSameRM(other.resource);
        }
        return this.resource.isSameRM(xares);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        LOG.log(System.Logger.Level.TRACE, () -> "prepare: " + XAResourceWrapper.xidToString(xid));
        int result = this.resource.prepare(xid);
        LOG.log(System.Logger.Level.DEBUG, () -> "prepare: " + XAResourceWrapper.xidToString(xid) + ", result=" + XAResourceWrapper.prepareResultToString(result));
        return result;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "recover: flag=" + XAResourceWrapper.flagToString(flag));
        return this.resource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "rollback: " + XAResourceWrapper.xidToString(xid));
        this.resource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "setTransactionTimeout: " + seconds + " s");
        return this.resource.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        LOG.log(System.Logger.Level.DEBUG, () -> "start: " + XAResourceWrapper.xidToString(xid) + ", flags=" + XAResourceWrapper.flagToString(flags));
        this.resource.start(xid, flags);
    }

    private static String xidToString(Xid xid) {
        return "XID[global/branch]=" + new String(xid.getGlobalTransactionId(), StandardCharsets.ISO_8859_1) + "/" + new String(xid.getBranchQualifier(), StandardCharsets.ISO_8859_1);
    }

    private static String flagToString(int flag) {
        switch (flag) {
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
        }
        return "UNKNOWN[" + Integer.toHexString(flag) + "]";
    }

    private static String prepareResultToString(int result) {
        switch (result) {
            case 3: {
                return "XA_RDONLY";
            }
            case 0: {
                return "XA_OK";
            }
        }
        return "UNKNOWN[" + result + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof XAResourceWrapper) {
            XAResource other = ((XAResourceWrapper)obj).resource;
            return this.resource.equals(other);
        }
        if (obj instanceof XAResource) {
            XAResource other = (XAResource)obj;
            return this.resource.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

