/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FelixPrettyPrinter {
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("\\[(\\d+)\\]", 8);

    public static void main(String[] args) {
        System.out.println(FelixPrettyPrinter.prettyPrintExceptionMessage("missing requirement [org.glassfish.hk2.osgi-adapter [142](R 142.0)] osgi.wiring.package; (&(osgi.wiring.package=com.sun.enterprise.module.bootstrap)(version>=3.0.0)(!(version>=4.0.0))) [caused by: Unable to resolve org.glassfish.hk2.core [232](R 232.0): missing requirement [org.glassfish.hk2.core [232](R 232.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.hk2.utilities)(version>=3.0.0)(!(version>=4.0.0))) [caused by: Unable to resolve org.glassfish.hk2.api [3](R 3.0): missing requirement [org.glassfish.hk2.api [3](R 3.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.hk2.utilities.reflection)(version>=3.0.0)(!(version>=4.0.0))) [caused by: Unable to resolve org.glassfish.hk2.utils [2](R 2.0): missing requirement [org.glassfish.hk2.utils [2](R 2.0)] osgi.wiring.package; (&(osgi.wiring.package=jakarta.annotation)(version>=2.1.0)(!(version>=3.0.0)))]]] Unresolved requirements: [[org.glassfish.hk2.osgi-adapter [142](R 142.0)] osgi.wiring.package; (&(osgi.wiring.package=com.sun.enterprise.module.bootstrap)(version>=3.0.0)(!(version>=4.0.0)))]"));
    }

    public static String prettyPrintFelixMessage(BundleContext context, String bundleMessage) {
        String prettyMessage = FelixPrettyPrinter.prettyPrintExceptionMessage(bundleMessage);
        List<Integer> bundleIDs = FelixPrettyPrinter.findBundleIds(prettyMessage);
        if (bundleIDs.isEmpty()) {
            return prettyMessage;
        }
        StringBuilder bundleBuilder = new StringBuilder(1024);
        bundleBuilder.append(prettyMessage);
        for (Integer bundleId : bundleIDs) {
            Bundle bundle = context.getBundle((long)bundleId.intValue());
            if (bundle == null) continue;
            bundleBuilder.append('[').append(bundleId).append("] \n");
            bundleBuilder.append("jar = ").append(bundle.getLocation());
            FelixPrettyPrinter.tryAddPomProperties(bundle, bundleBuilder);
            bundleBuilder.append('\n');
        }
        return bundleBuilder.toString();
    }

    public static String prettyPrintExceptionMessage(String message) {
        StringBuilder messageBuilder = new StringBuilder(256);
        try {
            int index = message.indexOf("Unable to resolve");
            int indent = 0;
            while (index >= 0) {
                FelixPrettyPrinter.printLn(messageBuilder, indent, "Unable to resolve");
                int index2 = message.indexOf("missing requirement", index += "Unable to resolve".length());
                if (index2 >= 0) {
                    boolean isPackage;
                    ++indent;
                    String module = message.substring(index, index2);
                    if (module.contains("(R")) {
                        module = module.substring(0, module.indexOf("(R"));
                    }
                    FelixPrettyPrinter.printLn(messageBuilder, indent, module);
                    FelixPrettyPrinter.printLn(messageBuilder, indent, "missing requirement");
                    index = index2 + "missing requirement".length();
                    int indexPackage = message.indexOf("osgi.wiring.package; ", index);
                    int indexHost = message.indexOf("osgi.wiring.host; ", index);
                    if (indexPackage < indexHost) {
                        index = indexPackage;
                        isPackage = true;
                    } else {
                        index = indexHost;
                        isPackage = false;
                    }
                    if (index >= 0) {
                        ++indent;
                        if (isPackage) {
                            index2 = message.indexOf(" ", index += "osgi.wiring.package; ".length());
                            String packageAndVersion = null;
                            packageAndVersion = index2 != -1 ? message.substring(index, index2) : message.substring(index);
                            packageAndVersion = packageAndVersion.replace("osgi.wiring.package", "package");
                            packageAndVersion = packageAndVersion.replace(")(", ") (");
                            packageAndVersion = packageAndVersion.replace("=", " = ");
                            packageAndVersion = packageAndVersion.replace("> =", " >=");
                            if ((packageAndVersion = packageAndVersion.replace("< =", " <=")).startsWith("(")) {
                                packageAndVersion = packageAndVersion.substring(1);
                            }
                            if (packageAndVersion.endsWith(")")) {
                                packageAndVersion = packageAndVersion.substring(0, packageAndVersion.length() - 1);
                            }
                            FelixPrettyPrinter.printLn(messageBuilder, indent, packageAndVersion);
                        } else {
                            index2 = message.indexOf("]", index += "osgi.wiring.host; ".length());
                            String remainder = null;
                            remainder = index2 != -1 ? message.substring(index, index2) : message.substring(index);
                            FelixPrettyPrinter.printLn(messageBuilder, indent, remainder);
                        }
                        index = message.indexOf("caused by: ", index2);
                        if (index >= 0) {
                            FelixPrettyPrinter.printLn(messageBuilder, indent, "caused by:");
                            ++indent;
                            index += "caused by: ".length();
                        }
                    }
                }
                if (index2 == -1) {
                    index = -1;
                    continue;
                }
                index = index2;
                index = message.indexOf("Unable to resolve", index);
            }
            return messageBuilder.toString();
        }
        catch (Exception e) {
            return message;
        }
    }

    public static String addBundleInfo(Bundle bundle, String prettyMessage) {
        StringBuilder bundleBuilder = new StringBuilder(1024);
        bundleBuilder.append("\n").append(prettyMessage);
        if (bundle != null) {
            bundleBuilder.append('[').append(bundle.getBundleId()).append("] \n");
            bundleBuilder.append("jar = ").append(bundle.getLocation());
            FelixPrettyPrinter.tryAddPomProperties(bundle, bundleBuilder);
            bundleBuilder.append('\n');
        }
        return bundleBuilder.toString();
    }

    private static void tryAddPomProperties(Bundle bundle, StringBuilder bundleBuilder) {
        Enumeration entries = bundle.findEntries("META-INF/maven/", "pom.properties", true);
        while (entries.hasMoreElements()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((URL)entries.nextElement()).openStream(), StandardCharsets.UTF_8));){
                reader.lines().filter(e -> !e.startsWith("#")).forEach(e -> bundleBuilder.append('\n').append(e.replace("=", " = ")));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bundleBuilder.append('\n');
        }
    }

    public static List<Integer> findBundleIds(String message) {
        if (message == null || message.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Integer> bundleIds = new LinkedHashSet<Integer>();
        Matcher bundlePattern = BUNDLE_PATTERN.matcher(message);
        while (bundlePattern.find()) {
            String number = bundlePattern.group(1);
            bundleIds.add(Integer.valueOf(number));
        }
        return new ArrayList<Integer>(bundleIds);
    }

    private static void printLn(StringBuilder messageBuilder, int indent, String message) {
        for (int i = 0; i < indent * 4; ++i) {
            messageBuilder.append(" ");
        }
        messageBuilder.append(message.trim()).append("\n");
    }
}

