/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.InvokerLogger;
import org.jboss.weld.logging.WeldLogger;

public class InvokerLogger_$logger
extends DelegatingBasicLogger
implements InvokerLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InvokerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public InvokerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidArgumentPosition$str() {
        return "WELD-002000: Cannot apply {0} to method argument with position {1}; total number of method parameters is {2}";
    }

    @Override
    public final IllegalArgumentException invalidArgumentPosition(String kindOfTransformer, int position, int argLookupLength) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidArgumentPosition$str(), kindOfTransformer, position, argLookupLength));
        InvokerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String settingTransformerRepeatedly$str() {
        return "WELD-002001: {0} transformer is already set! InvokerBuilder transformers cannot be set repeatedly.";
    }

    @Override
    public final IllegalArgumentException settingTransformerRepeatedly(String kindOfTransformer) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.settingTransformerRepeatedly$str(), kindOfTransformer));
        InvokerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTransformerMethod$str() {
        return "WELD-002002: Invalid {0} transformer method: {1}";
    }

    @Override
    public final IllegalStateException invalidTransformerMethod(String kindOfTransformer, Object transformerMetadata) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidTransformerMethod$str(), kindOfTransformer, transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMatchingTransformerMethod$str() {
        return "WELD-002003: No matching transformer method found for {0}. There has to be exactly one matching method.";
    }

    @Override
    public final IllegalStateException noMatchingTransformerMethod(Object transformerMetadata) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.noMatchingTransformerMethod$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleMatchingTransformerMethod$str() {
        return "WELD-002004: Multiple matching transformer methods found for {0}. There has to be exactly one matching method; instead, following methods were found: {1}";
    }

    @Override
    public final DeploymentException multipleMatchingTransformerMethod(Object transformerMetadata, Object listOfMatches) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.multipleMatchingTransformerMethod$str(), transformerMetadata, listOfMatches));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String cannotCreateMethodHandle$str() {
        return "WELD-002005: Unable to create method handle for method: {0}";
    }

    @Override
    public final RuntimeException cannotCreateMethodHandle(Object method, Throwable cause) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.cannotCreateMethodHandle$str(), method), cause);
        InvokerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonPublicTransformer$str() {
        return "WELD-002006: All invocation transformers need to be public - {0}";
    }

    @Override
    public final DeploymentException nonPublicTransformer(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.nonPublicTransformer$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String inputTransformerNotAssignable$str() {
        return "WELD-002007: Input transformer {0} has a return value that is not assignable to expected class: {1}";
    }

    @Override
    public final DeploymentException inputTransformerNotAssignable(Object transformerMetadata, Object clazz) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.inputTransformerNotAssignable$str(), transformerMetadata, clazz));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String nonStaticInputTransformerHasParams$str() {
        return "WELD-002008: Non-static input transformers are expected to have zero input parameters! Transformer: {0}";
    }

    @Override
    public final DeploymentException nonStaticInputTransformerHasParams(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.nonStaticInputTransformerHasParams$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String staticInputTransformerParams$str() {
        return "WELD-002009: Static input transformers can only have one or two parameters! Transformer: {0}";
    }

    @Override
    public final DeploymentException staticInputTransformerParams(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.staticInputTransformerParams$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String staticInputTransformerIncorrectParams$str() {
        return "WELD-002010: Static input transformers with two parameters can only have Consumer<Runnable> as their second parameter! Transformer: {0}";
    }

    @Override
    public final DeploymentException staticInputTransformerIncorrectParams(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.staticInputTransformerIncorrectParams$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String nonStaticOutputTransformerHasParams$str() {
        return "WELD-002011: Non-static output transformers are expected to have zero input parameters! Transformer: {0}";
    }

    @Override
    public final DeploymentException nonStaticOutputTransformerHasParams(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.nonStaticOutputTransformerHasParams$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String staticOutputTransformerParams$str() {
        return "WELD-002012: Static output transformers are expected to have one input parameter! Transformer: {0}";
    }

    @Override
    public final DeploymentException staticOutputTransformerParams(Object transformerMetadata) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.staticOutputTransformerParams$str(), transformerMetadata));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String outputTransformerNotAssignable$str() {
        return "WELD-002013: Output transformer {0} parameter is not assignable to the expected class: {1}";
    }

    @Override
    public final DeploymentException outputTransformerNotAssignable(Object transformerMetadata, Object clazz) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.outputTransformerNotAssignable$str(), transformerMetadata, clazz));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String wrapperUnexpectedParams$str() {
        return "WELD-002014: Invocation wrapper has unexpected parameters: {0} \nExpected param types are: {1}, Object[], Invoker.class";
    }

    @Override
    public final DeploymentException wrapperUnexpectedParams(Object transformerMetadata, Object clazz) {
        DeploymentException result = new DeploymentException(this._formatMessage(this.wrapperUnexpectedParams$str(), transformerMetadata, clazz));
        InvokerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

