/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.admin.adapter.ConsoleLoadingOption;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="AdminConsoleStartupService")
@RunLevel(value=20)
public class AdminConsoleStartupService {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    @Inject
    @Optional
    private AdminConsoleAdapter adminConsoleAdapter;
    @Inject
    private ServerEnvironmentImpl serverEnvironment;

    @PostConstruct
    public void postConstruct() {
        if (this.adminConsoleAdapter == null) {
            return;
        }
        if (!this.serverEnvironment.isDas()) {
            return;
        }
        ConsoleLoadingOption loadingOption = this.adminConsoleAdapter.getLoadingOption();
        logger.log(Level.FINE, "AdminConsoleStartupService: Console loading option is {0}", (Object)loadingOption);
        if (loadingOption == ConsoleLoadingOption.ALWAYS) {
            this.handleAlways();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAlways() {
        this.adminConsoleAdapter.initRest();
        AdminConsoleStartupService adminConsoleStartupService = this;
        synchronized (adminConsoleStartupService) {
            if (!this.adminConsoleAdapter.isInstalling() && !this.adminConsoleAdapter.isApplicationLoaded()) {
                this.adminConsoleAdapter.loadConsole();
            }
        }
    }
}

