/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.annotation.handlers.ContextServiceDefinitionData;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.annotations.Service;

@Service
class ContextServiceDefinitionConverter {
    private static final System.Logger LOG = System.getLogger(ContextServiceDefinitionConverter.class.getName());

    ContextServiceDefinitionConverter() {
    }

    Set<ContextServiceDefinitionData> convert(ContextServiceDefinition[] definitions) {
        LOG.log(System.Logger.Level.TRACE, "convert(definitions={0})", new Object[]{definitions});
        if (definitions == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(definitions).map(this::convert).collect(Collectors.toSet());
    }

    ContextServiceDefinitionData convert(ContextServiceDefinition definition) {
        LOG.log(System.Logger.Level.DEBUG, "convert(definition={0})", definition);
        Set<String> unused = this.collectUnusedContexts(definition);
        ContextServiceDefinitionData data = new ContextServiceDefinitionData();
        data.setName(new SimpleJndiName(TranslatedConfigView.expandValue((String)definition.name())));
        data.setPropagated(this.evaluateContexts(definition.propagated(), unused));
        data.setCleared(this.evaluateContexts(definition.cleared(), unused));
        data.setUnchanged(this.evaluateContexts(definition.unchanged(), unused));
        return data;
    }

    private Set<String> collectUnusedContexts(ContextServiceDefinition definition) {
        boolean previous;
        HashSet<String> usedContexts = new HashSet<String>();
        for (String context : definition.propagated()) {
            usedContexts.add(context);
        }
        for (String context : definition.cleared()) {
            previous = usedContexts.add(context);
            if (previous) continue;
            throw new IllegalArgumentException("Duplicit context " + context + " in " + usedContexts + " and cleared context attributes in ContextServiceDefinition annotation!");
        }
        for (String context : definition.unchanged()) {
            previous = usedContexts.add(context);
            if (previous) continue;
            throw new IllegalArgumentException("Duplicit context " + context + " in " + previous + " and unchanged context attributes in ContextServiceDefinition annotation!");
        }
        HashSet<String> allStandardContexts = new HashSet<String>(Set.of("Application", "Security", "Transaction"));
        allStandardContexts.removeAll(usedContexts);
        return allStandardContexts;
    }

    private Set<String> evaluateContexts(String[] sourceContexts, Set<String> unusedContexts) {
        HashSet<String> contexts = new HashSet<String>();
        for (String context : sourceContexts) {
            if ("Remaining".equals(context)) {
                contexts.addAll(unusedContexts);
                contexts.add("Remaining");
                continue;
            }
            contexts.add(context);
        }
        return contexts;
    }
}

