/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.acl;

import com.sun.enterprise.security.ee.acl.RoleMapper;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RoleMapperFactory
implements SecurityRoleMapperFactory {
    private Map<String, String> contextToAppName = new ConcurrentHashMap<String, String>();
    private Map<String, SecurityRoleMapper> appNameToRoleMapper = new ConcurrentHashMap<String, SecurityRoleMapper>();

    public SecurityRoleMapper getRoleMapper(String appName) {
        String contextId = appName;
        String appname = this.getAppNameForContext(appName);
        SecurityRoleMapper securityRoleMapper = null;
        if (appname != null) {
            securityRoleMapper = this.getRoleMapper(appname, this);
        }
        if (securityRoleMapper == null) {
            securityRoleMapper = this.getRoleMapper(contextId, this);
        }
        return securityRoleMapper;
    }

    public String getAppNameForContext(String contextId) {
        return this.contextToAppName.get(contextId);
    }

    public void setAppNameForContext(String appName, String contextId) {
        this.contextToAppName.put(contextId, appName);
    }

    public void removeAppNameForContext(String contextId) {
        this.contextToAppName.remove(contextId);
    }

    public SecurityRoleMapper getRoleMapper(String appName, SecurityRoleMapperFactory securityRoleMapperFactory) {
        return this.appNameToRoleMapper.computeIfAbsent(appName, RoleMapper::new);
    }

    public void setRoleMapper(String appName, SecurityRoleMapper securityRoleMapper) {
        this.appNameToRoleMapper.put(appName, securityRoleMapper);
    }

    public void removeRoleMapper(String appName) {
        if (this.appNameToRoleMapper.containsKey(appName)) {
            this.appNameToRoleMapper.remove(appName);
        }
    }
}

