/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.ScheduledEvent;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.IntegerConverter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.beans.Beans;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

public final class CalendarMonth
extends UIOutput
implements NamingContainer {
    private static final boolean DEBUG = false;
    public static final String MONTH_MENU_ID = "monthMenu";
    public static final String YEAR_MENU_ID = "yearMenu";
    public static final String PREVIOUS_MONTH_LINK_ID = "previousMonthLink";
    public static final String NEXT_MONTH_LINK_ID = "nextMonthLink";
    public static final String DATE_LINK_ID = "dateLink";
    public static final String DATE_FIELD_ID = "dateField";
    public static final String DATE_FORMAT_ATTR = "dateFormatAttr";
    public static final String DATE_FORMAT_PATTERN_ATTR = "dateFormatPatternAttr";
    private static final String TIME_ZONE_ATTR = "timeZoneAttr";
    private Calendar calendar = null;
    private String javaScriptObjectName = null;
    private boolean popup = false;
    private boolean popupSet = false;

    public CalendarMonth() {
        this.setRendererType("com.sun.webui.jsf.CalendarMonth");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.CalendarMonth";
    }

    public boolean isDateSelected(Calendar current, Calendar endDate) {
        Object value = this.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof Date) {
            Calendar cal = this.getCalendar();
            cal.setTime((Date)value);
            return this.compareDate(cal, current);
        }
        if (value instanceof ScheduledEvent) {
            Iterator dates = ((ScheduledEvent)value).getDates(endDate);
            while (dates.hasNext()) {
                Calendar cal = (Calendar)dates.next();
                if (!this.compareDate(cal, current)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean compareDate(Calendar selected, Calendar current) {
        return selected.get(1) == current.get(1) && selected.get(2) == current.get(2) && selected.get(5) == current.get(5);
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.initializeCalendar();
        }
        return (Calendar)this.calendar.clone();
    }

    private void initializeCalendar() {
        Locale locale = CalendarMonth.getLocale();
        TimeZone tz = this.getTimeZone();
        this.calendar = tz == null ? Calendar.getInstance(locale) : Calendar.getInstance(tz, locale);
    }

    public DateFormat getDateFormat() {
        Object o = this.getAttributes().get(DATE_FORMAT_ATTR);
        if (o != null && o instanceof DateFormat) {
            DateFormat dateFormat = (DateFormat)o;
            return dateFormat;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, CalendarMonth.getLocale());
        simpleDateFormat.setCalendar(this.getCalendar());
        simpleDateFormat.applyPattern(this.getDateFormatPattern(simpleDateFormat));
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(DATE_FORMAT_ATTR, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public TimeZone getTimeZone() {
        Object tzo = this.getAttributes().get(TIME_ZONE_ATTR);
        if (tzo != null && tzo instanceof TimeZone) {
            return (TimeZone)tzo;
        }
        UIComponent parent = this.getParent();
        TimeZone tz = null;
        try {
            tz = ((DateManager)parent).getTimeZone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tz == null) {
            tz = Calendar.getInstance(CalendarMonth.getLocale()).getTimeZone();
        }
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(TIME_ZONE_ATTR, tz);
        }
        if (tz == null) {
            return TimeZone.getDefault();
        }
        return tz;
    }

    public void setTimeZone(TimeZone tz) {
        this.getAttributes().remove(TIME_ZONE_ATTR);
        this.calendar = null;
    }

    public DropDown getMonthMenu() {
        DropDown monthMenu;
        UIComponent comp = this.getFacet(MONTH_MENU_ID);
        if (comp == null || !(comp instanceof DropDown)) {
            monthMenu = new DropDown();
            monthMenu.setSubmitForm(true);
            monthMenu.setConverter((Converter)new IntegerConverter());
            monthMenu.setId(MONTH_MENU_ID);
            if (!this.isPopup()) {
                monthMenu.setImmediate(true);
            }
            this.getFacets().put(MONTH_MENU_ID, monthMenu);
        } else {
            monthMenu = (DropDown)comp;
        }
        return monthMenu;
    }

    public DropDown getYearMenu() {
        DropDown yearMenu = (DropDown)this.getFacets().get(YEAR_MENU_ID);
        if (yearMenu == null) {
            yearMenu = new DropDown();
            yearMenu.setSubmitForm(true);
            yearMenu.setId(YEAR_MENU_ID);
            yearMenu.setConverter((Converter)new IntegerConverter());
            if (!this.isPopup()) {
                yearMenu.setImmediate(true);
            }
            this.getFacets().put(YEAR_MENU_ID, yearMenu);
        }
        return yearMenu;
    }

    public IconHyperlink getPreviousMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(PREVIOUS_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(PREVIOUS_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_BACKWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.setImmediate(true);
                link.addActionListener(new PreviousMonthListener());
            }
            this.getFacets().put(PREVIOUS_MONTH_LINK_ID, link);
        }
        return link;
    }

    public IconHyperlink getNextMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(NEXT_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(NEXT_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_FORWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.addActionListener(new NextMonthListener());
                link.setImmediate(true);
            }
            this.getFacets().put(NEXT_MONTH_LINK_ID, link);
        }
        return link;
    }

    protected Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public void initCalendarControls(String jsName) {
        StringBuffer js = new StringBuffer().append(jsName).append(".decreaseMonth(); return false;");
        IconHyperlink link = this.getPreviousMonthLink();
        link.setIcon("CALENDAR_BACKWARD");
        link.setOnClick(js.toString());
        js = new StringBuffer().append(jsName).append(".increaseMonth(); return false;");
        link = this.getNextMonthLink();
        link.setIcon("CALENDAR_FORWARD");
        link.setOnClick(js.toString());
        this.getMonthMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
        this.getYearMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
    }

    public void showNextMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month < 12) {
            int newMonth = month + 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showNextYear()) {
            monthMenu.setSubmittedValue(new String[]{"1"});
        }
    }

    public void showPreviousMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month > 1) {
            int newMonth = month - 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showPreviousYear()) {
            monthMenu.setSubmittedValue(new String[]{"12"});
        }
    }

    private boolean showNextYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer lastYear = (Integer)options[options.length - 1].getValue();
        if (lastYear >= ++year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    private boolean showPreviousYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer firstYear = (Integer)options[0].getValue();
        if (firstYear <= --year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    public Integer getCurrentMonth() {
        DropDown monthMenu = this.getMonthMenu();
        Object value = monthMenu.getSubmittedValue();
        Integer month = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                month = Integer.decode(vals[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            value = monthMenu.getValue();
            if (value != null && value instanceof Integer) {
                month = (Integer)value;
            }
        }
        return month;
    }

    public Integer getCurrentYear() {
        DropDown yearMenu = this.getYearMenu();
        Object value = yearMenu.getSubmittedValue();
        Integer year = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                year = Integer.decode(vals[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            value = yearMenu.getValue();
            if (value != null && value instanceof Integer) {
                year = (Integer)value;
            }
        }
        return year;
    }

    public String getJavaScriptObjectName() {
        return this.javaScriptObjectName;
    }

    public void setJavaScriptObjectName(String jsObjectName) {
        this.javaScriptObjectName = jsObjectName;
    }

    public String getDateFormatPattern() {
        return this.getDateFormatPattern(null);
    }

    public String getDateFormatPattern(SimpleDateFormat dateFormat) {
        SimpleDateFormat format = dateFormat;
        if (format == null) {
            Object dfp = this.getAttributes().get(DATE_FORMAT_PATTERN_ATTR);
            Object pattern = null;
            if (dfp != null && dfp instanceof String) {
                return (String)dfp;
            }
            format = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, CalendarMonth.getLocale());
        }
        String pattern = null;
        UIComponent parent = this.getParent();
        if (parent != null && parent instanceof DateManager) {
            pattern = ((DateManager)parent).getDateFormatPattern();
        }
        if (pattern == null) {
            pattern = format.toPattern();
            if (!pattern.contains("yyyy")) {
                pattern = pattern.replaceFirst("yy", "yyyy");
            }
            if (!pattern.contains("MM")) {
                pattern = pattern.replaceFirst("M", "MM");
            }
            if (!pattern.contains("dd")) {
                pattern = pattern.replaceFirst("d", "dd");
            }
        }
        format.applyPattern(pattern);
        pattern = format.toPattern();
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(DATE_FORMAT_PATTERN_ATTR, pattern);
        }
        return pattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.getAttributes().remove(DATE_FORMAT_PATTERN_ATTR);
        this.getAttributes().remove(DATE_FORMAT_ATTR);
    }

    public void displayValue() {
        DropDown monthMenu = this.getMonthMenu();
        DropDown yearMenu = this.getYearMenu();
        Object value = this.getValue();
        if (value == null) {
            monthMenu.setValue(null);
            yearMenu.setValue(null);
        } else if (value instanceof Date) {
            Calendar cal = this.getCalendar();
            cal.setTime((Date)value);
            int newMonth = cal.get(2) + 1;
            monthMenu.setValue(newMonth);
            int newYear = cal.get(1);
            yearMenu.setValue(newYear);
        } else if (value instanceof ScheduledEvent) {
            Date date = ((ScheduledEvent)value).getStartTime();
            if (date != null) {
                Calendar cal = this.getCalendar();
                cal.setTime(date);
                int newMonth = cal.get(2) + 1;
                monthMenu.setValue(newMonth);
                int newYear = cal.get(1);
                yearMenu.setValue(newYear);
            } else {
                monthMenu.setValue(null);
                yearMenu.setValue(null);
            }
        }
        monthMenu.setSubmittedValue(null);
        yearMenu.setSubmittedValue(null);
    }

    public boolean isPopup() {
        if (this.popupSet) {
            return this.popup;
        }
        ValueExpression vb = this.getValueExpression("popup");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setPopup(boolean newPop) {
        this.popup = newPop;
        this.popupSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.popup = (Boolean)values[1];
        this.popupSet = (Boolean)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.popup ? Boolean.TRUE : Boolean.FALSE, this.popupSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    private static Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    private static void log(String msg) {
        LogUtil.finest(CalendarMonth.class.getName() + "::" + msg);
    }

    private static final class NextMonthListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -6726256680698229686L;

        private NextMonthListener() {
        }

        public void processAction(ActionEvent event) {
            FacesContext.getCurrentInstance().renderResponse();
            UIComponent comp = event.getComponent();
            comp = comp.getParent();
            if (comp instanceof CalendarMonth) {
                ((CalendarMonth)comp).showNextMonth();
            }
        }
    }

    private static final class PreviousMonthListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 214378156127977786L;

        private PreviousMonthListener() {
        }

        public void processAction(ActionEvent event) {
            FacesContext.getCurrentInstance().renderResponse();
            UIComponent comp = event.getComponent();
            comp = comp.getParent();
            if (comp instanceof CalendarMonth) {
                ((CalendarMonth)comp).showPreviousMonth();
            }
        }
    }
}

