/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigThreadFactory;
import io.helidon.config.spi.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public final class SimpleRetryPolicy
implements RetryPolicy {
    private static final System.Logger LOGGER = System.getLogger(SimpleRetryPolicy.class.getName());
    private final int retries;
    private final Duration delay;
    private final double delayFactor;
    private final Duration callTimeout;
    private final Duration overallTimeout;
    private final ScheduledExecutorService executorService;
    private volatile ScheduledFuture<?> future;

    private SimpleRetryPolicy(Builder builder) {
        this.retries = builder.retries;
        this.delay = builder.delay;
        this.delayFactor = builder.delayFactor;
        this.callTimeout = builder.callTimeout;
        this.overallTimeout = builder.overallTimeout;
        this.executorService = builder.executorService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SimpleRetryPolicy create(Config metaConfig) {
        return SimpleRetryPolicy.builder().config(metaConfig).build();
    }

    public <T> T execute(Supplier<T> call) throws ConfigException {
        Duration currentDelay = Duration.ZERO;
        long overallTimeoutsLeft = this.overallTimeout.toMillis();
        Throwable last = null;
        for (int i = 0; i <= this.retries; ++i) {
            try {
                LOGGER.log(System.Logger.Level.DEBUG, "next delay: " + String.valueOf(currentDelay));
                if ((overallTimeoutsLeft -= currentDelay.toMillis()) < 0L) {
                    LOGGER.log(System.Logger.Level.DEBUG, "overall timeout left [ms]: " + overallTimeoutsLeft);
                    throw new ConfigException("Cannot schedule the next call, the current delay would exceed the overall timeout.");
                }
                ScheduledFuture<Object> localFuture = this.executorService.schedule(call::get, currentDelay.toMillis(), TimeUnit.MILLISECONDS);
                this.future = localFuture;
                return (T)localFuture.get(Math.min(currentDelay.plus(this.callTimeout).toMillis(), overallTimeoutsLeft), TimeUnit.MILLISECONDS);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw new ConfigException("An invocation has been canceled.", e);
            }
            catch (InterruptedException e) {
                throw new ConfigException("An invocation has been interrupted.", e);
            }
            catch (TimeoutException e) {
                throw new ConfigException("A timeout has been reached.", e);
            }
            catch (Throwable t) {
                last = t;
                currentDelay = this.nextDelay(i, currentDelay);
                continue;
            }
        }
        throw new ConfigException("All repeated calls failed.", last);
    }

    Duration nextDelay(int invocation, Duration currentDelay) {
        if (invocation == 0) {
            return this.delay;
        }
        return Duration.ofMillis((long)((double)currentDelay.toMillis() * this.delayFactor));
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.future != null && !this.future.isDone() && !this.future.isCancelled()) {
            return this.future.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    public int retries() {
        return this.retries;
    }

    public Duration delay() {
        return this.delay;
    }

    public double delayFactor() {
        return this.delayFactor;
    }

    public Duration callTimeout() {
        return this.callTimeout;
    }

    public Duration overallTimeout() {
        return this.overallTimeout;
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, SimpleRetryPolicy> {
        private int retries = 3;
        private Duration delay = Duration.ofMillis(200L);
        private double delayFactor = 2.0;
        private Duration callTimeout = Duration.ofMillis(500L);
        private Duration overallTimeout = Duration.ofSeconds(2L);
        private ScheduledExecutorService executorService;

        private Builder() {
        }

        public SimpleRetryPolicy build() {
            if (null == this.executorService) {
                this.executorService = Executors.newSingleThreadScheduledExecutor(new ConfigThreadFactory("retry-policy"));
            }
            return new SimpleRetryPolicy(this);
        }

        public Builder config(Config metaConfig) {
            metaConfig.get("retries").asInt().ifPresent(this::retries);
            metaConfig.get("delay").as(Duration.class).ifPresent(this::delay);
            metaConfig.get("delay-factor").asDouble().ifPresent(this::delayFactor);
            metaConfig.get("call-timeout").as(Duration.class).ifPresent(this::callTimeout);
            metaConfig.get("overall-timeout").as(Duration.class).ifPresent(this::overallTimeout);
            return this;
        }

        public Builder retries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Builder delayFactor(double delayFactor) {
            this.delayFactor = delayFactor;
            return this;
        }

        public Builder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder overallTimeout(Duration overallTimeout) {
            this.overallTimeout = overallTimeout;
            return this;
        }

        public Builder executorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

