/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.formatter.LogFormatDetector;
import org.glassfish.main.jul.formatter.UniformLogFormatter;
import org.glassfish.main.jul.handler.ExternallyManagedLogHandler;
import org.glassfish.main.jul.handler.GlassFishLogHandlerConfiguration;
import org.glassfish.main.jul.handler.GlassFishLogHandlerProperty;
import org.glassfish.main.jul.handler.HandlerConfigurationHelper;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.handler.LoggingPrintStream;
import org.glassfish.main.jul.handler.LoggingPumpThread;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;
import org.glassfish.main.jul.rotation.DailyLogRotationTimerTask;
import org.glassfish.main.jul.rotation.LogFileManager;
import org.glassfish.main.jul.rotation.LogRotationTimerTask;
import org.glassfish.main.jul.rotation.PeriodicalLogRotationTimerTask;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class GlassFishLogHandler
extends Handler
implements ExternallyManagedLogHandler {
    private static final String LOGGER_NAME_STDOUT = "jakarta.enterprise.logging.stdout";
    private static final String LOGGER_NAME_STDERR = "jakarta.enterprise.logging.stderr";
    private static final Logger STDOUT_LOGGER = Logger.getLogger("jakarta.enterprise.logging.stdout");
    private static final Logger STDERR_LOGGER = Logger.getLogger("jakarta.enterprise.logging.stderr");
    private static final MessageResolver MSG_RESOLVER = new MessageResolver();
    private final ReentrantLock lock = new ReentrantLock();
    private LoggingPrintStream stdoutStream;
    private LoggingPrintStream stderrStream;
    private final LogRecordBuffer logRecordBuffer;
    private LogRotationTimerTask rotationTimerTask;
    private GlassFishLogHandlerConfiguration configuration;
    private final Timer rotationTimer = new Timer("log-rotation-timer-for-" + this.getClass().getSimpleName(), true);
    private volatile GlassFishLogHandlerStatus status;
    private LoggingPump pump;
    private LogFileManager logFileManager;
    private boolean doneHeader;

    public static GlassFishLogHandlerConfiguration createGlassFishLogHandlerConfiguration(Class<? extends GlassFishLogHandler> handlerClass) {
        HandlerConfigurationHelper helper = HandlerConfigurationHelper.forHandlerClass(handlerClass);
        GlassFishLogHandlerConfiguration configuration = new GlassFishLogHandlerConfiguration();
        configuration.setLevel(helper.getLevel(GlassFishLogHandlerProperty.LEVEL, Level.ALL));
        configuration.setEncoding(helper.getCharset(GlassFishLogHandlerProperty.ENCODING, StandardCharsets.UTF_8));
        configuration.setEnabled(helper.getBoolean(GlassFishLogHandlerProperty.ENABLED, true));
        configuration.setLogFile(helper.getFile(GlassFishLogHandlerProperty.OUTPUT_FILE, null));
        configuration.setRedirectStandardStreams(helper.getBoolean(GlassFishLogHandlerProperty.REDIRECT_STANDARD_STREAMS, Boolean.FALSE));
        configuration.setFlushFrequency(helper.getNonNegativeInteger(GlassFishLogHandlerProperty.FLUSH_FREQUENCY, 1));
        configuration.setBufferCapacity(helper.getInteger(GlassFishLogHandlerProperty.BUFFER_CAPACITY, 10000));
        configuration.setBufferTimeout(helper.getInteger(GlassFishLogHandlerProperty.BUFFER_TIMEOUT, 0));
        Integer rotationLimitMB = helper.getInteger(GlassFishLogHandlerProperty.ROTATION_LIMIT_SIZE, 100);
        long rotationLimitB = 1000000L * (long)(rotationLimitMB >= 1 ? rotationLimitMB : 100);
        configuration.setRotationSizeLimitBytes(rotationLimitB);
        configuration.setCompressionOnRotation(helper.getBoolean(GlassFishLogHandlerProperty.ROTATION_COMPRESS, Boolean.FALSE));
        configuration.setRotationOnDateChange(helper.getBoolean(GlassFishLogHandlerProperty.ROTATION_ON_DATE_CHANGE, Boolean.FALSE));
        configuration.setRotationTimeLimitMinutes(helper.getNonNegativeInteger(GlassFishLogHandlerProperty.ROTATION_LIMIT_TIME, 0));
        configuration.setMaxArchiveFiles(helper.getNonNegativeInteger(GlassFishLogHandlerProperty.ROTATION_MAX_HISTORY, 10));
        Formatter formatter = helper.getFormatter(UniformLogFormatter.class);
        configuration.setFormatterConfiguration(formatter);
        return configuration;
    }

    public GlassFishLogHandler() {
        this(GlassFishLogHandler.createGlassFishLogHandlerConfiguration(GlassFishLogHandler.class));
    }

    public GlassFishLogHandler(GlassFishLogHandlerConfiguration configuration) {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, () -> "GlassFishLogHandler(configuration=" + String.valueOf(configuration) + ")");
        this.setLevel(configuration.getLevel());
        this.setEncoding(configuration.getEncoding());
        this.logRecordBuffer = new LogRecordBuffer(configuration.getBufferCapacity(), configuration.getBufferTimeout());
        this.reconfigure(configuration);
    }

    @Override
    public boolean isReady() {
        return this.status == GlassFishLogHandlerStatus.ON || !this.configuration.isEnabled();
    }

    private void setEncoding(Charset encoding) {
        try {
            super.setEncoding(encoding.name());
        }
        catch (UnsupportedEncodingException | SecurityException e) {
            throw new IllegalStateException("Reached unreachable exception.", e);
        }
    }

    public GlassFishLogHandlerConfiguration getConfiguration() {
        return this.configuration.clone();
    }

    public void reconfigure(GlassFishLogHandlerConfiguration newConfiguration) {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, () -> "reconfigure(configuration=" + String.valueOf(newConfiguration) + ")");
        this.lock.lock();
        try {
            this.status = GlassFishLogHandlerStatus.ACCEPTING;
            this.logRecordBuffer.reconfigure(newConfiguration.getBufferCapacity(), newConfiguration.getBufferTimeout());
            if (this.rotationTimerTask != null) {
                this.rotationTimerTask.cancel();
                this.rotationTimerTask = null;
            }
            this.stopPump();
            this.configuration = newConfiguration;
            try {
                this.status = this.startLoggingIfPossible();
            }
            catch (Exception e) {
                this.status = GlassFishLogHandlerStatus.OFF;
                throw e;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.status == GlassFishLogHandlerStatus.OFF) {
            return;
        }
        if (this.status == GlassFishLogHandlerStatus.ACCEPTING) {
            this.logRecordBuffer.add(MSG_RESOLVER.resolve(record));
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        GlassFishLogRecord enhancedLogRecord = MSG_RESOLVER.resolve(record);
        this.logRecordBuffer.add(enhancedLogRecord);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.configuration.isEnabled() && (this.status == GlassFishLogHandlerStatus.ACCEPTING || super.isLoggable(record));
    }

    @Override
    public void flush() {
        if (this.logFileManager != null) {
            this.logFileManager.flush();
        }
    }

    public void roll() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "roll()");
        PrivilegedAction<Void> action = () -> {
            this.logFileManager.roll();
            this.updateRollSchedule();
            return null;
        };
        this.lock.lock();
        try {
            AccessController.doPrivileged(action);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "close()");
        this.lock.lock();
        try {
            this.status = GlassFishLogHandlerStatus.OFF;
            if (this.rotationTimerTask != null) {
                this.rotationTimerTask.cancel();
                this.rotationTimerTask = null;
            }
            this.rotationTimer.cancel();
            try {
                LoggingSystemEnvironment.resetStandardOutputs();
                if (this.stdoutStream != null) {
                    this.stdoutStream.close();
                    this.stdoutStream = null;
                }
                if (this.stderrStream != null) {
                    this.stderrStream.close();
                    this.stderrStream = null;
                }
            }
            catch (RuntimeException e) {
                GlassFishLoggingTracer.error(GlassFishLogHandler.class, "close partially failed!", e);
            }
            this.stopPump();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return super.toString() + "[status=" + String.valueOf((Object)this.status) + ", buffer=" + String.valueOf(this.logRecordBuffer) + ", file=" + String.valueOf(this.configuration.getLogFile()) + "]";
    }

    private GlassFishLogHandlerStatus startLoggingIfPossible() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "startLoggingIfPossible()");
        if (!this.configuration.isEnabled()) {
            GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "Output is disabled, the handler will not process any records.");
            return GlassFishLogHandlerStatus.OFF;
        }
        if (this.configuration.getLogFile() == null) {
            GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "Output file is not set, but acceptation will start.");
            return GlassFishLogHandlerStatus.ACCEPTING;
        }
        this.logFileManager = new LogFileManager(this.configuration.getLogFile(), this.configuration.getEncoding(), this.configuration.getRotationSizeLimitBytes(), this.configuration.isCompressionOnRotation(), this.configuration.getMaxArchiveFiles());
        Formatter formatter = this.configuration.getFormatterConfiguration();
        this.setFormatter(formatter);
        if (GlassFishLogHandler.isRollRequired(this.configuration.getLogFile(), formatter, this.configuration.getEncoding())) {
            this.logFileManager.roll();
        }
        this.logFileManager.enableOutput();
        this.updateRollSchedule();
        if (this.configuration.isRedirectStandardStreams()) {
            this.initStandardStreamsLogging();
        } else {
            LoggingSystemEnvironment.resetStandardOutputs();
        }
        this.pump = new LoggingPump("GlassFishLogHandler log pump", this.logRecordBuffer);
        this.pump.start();
        return GlassFishLogHandlerStatus.ON;
    }

    private void stopPump() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "stopPump()");
        if (this.pump != null) {
            this.pump.interrupt();
            this.pump = null;
        }
        if (this.logFileManager == null) {
            return;
        }
        if (this.logFileManager.isOutputEnabled()) {
            this.drainLogRecords();
        }
        this.logFileManager.disableOutput();
        this.logFileManager = null;
    }

    private void drainLogRecords() {
        long counter = this.logRecordBuffer.getSize();
        while (counter-- >= 0L) {
            if (this.publishRecord(this.logRecordBuffer.poll())) continue;
            return;
        }
    }

    private void initStandardStreamsLogging() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "initStandardStreamsLogging()");
        LoggingPrintStream prevStdoutStream = this.stdoutStream;
        LoggingPrintStream prevStderrStream = this.stderrStream;
        this.stdoutStream = LoggingPrintStream.create(STDOUT_LOGGER, Level.INFO, 5000, this.configuration.getEncoding());
        this.stderrStream = LoggingPrintStream.create(STDERR_LOGGER, Level.SEVERE, 1000, this.configuration.getEncoding());
        System.setOut(this.stdoutStream);
        System.setErr(this.stderrStream);
        if (prevStdoutStream != null) {
            prevStdoutStream.close();
        }
        if (prevStderrStream != null) {
            prevStderrStream.close();
        }
    }

    private void updateRollSchedule() {
        GlassFishLoggingTracer.trace(GlassFishLogHandler.class, "updateRollSchedule()");
        if (this.rotationTimerTask != null) {
            this.rotationTimerTask.cancel();
            this.rotationTimerTask = null;
        }
        if (this.configuration.isRotationOnDateChange()) {
            this.rotationTimerTask = new DailyLogRotationTimerTask(this::scheduledRoll);
            this.rotationTimer.schedule((TimerTask)this.rotationTimerTask, this.rotationTimerTask.computeDelayInMillis());
        } else if (this.configuration.getRotationTimeLimitMinutes() > 0) {
            long delayInMillis = (long)(this.configuration.getRotationTimeLimitMinutes() * 60) * 1000L;
            this.rotationTimerTask = new PeriodicalLogRotationTimerTask(this::scheduledRoll, delayInMillis);
            this.rotationTimer.schedule((TimerTask)this.rotationTimerTask, this.rotationTimerTask.computeDelayInMillis());
        }
    }

    private void scheduledRoll() {
        this.lock.lock();
        try {
            this.logFileManager.rollIfFileNotEmpty();
            this.updateRollSchedule();
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean publishRecord(GlassFishLogRecord record) {
        String msg;
        if (record == null) {
            return false;
        }
        if (!this.isLoggable(record)) {
            return true;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return true;
        }
        if (!this.doneHeader) {
            this.logFileManager.write(this.getFormatter().getHead(this));
            this.doneHeader = true;
        }
        this.logFileManager.write(msg);
        return true;
    }

    private static boolean isRollRequired(File logFile, Formatter formatter, Charset expectedCharset) {
        if (logFile.length() == 0L) {
            return false;
        }
        String detectedFormatterName = new LogFormatDetector().detectFormatter(logFile, expectedCharset);
        return detectedFormatterName == null || !formatter.getClass().getName().equals(detectedFormatterName);
    }

    private static enum GlassFishLogHandlerStatus {
        OFF,
        ACCEPTING,
        ON;

    }

    private final class LoggingPump
    extends LoggingPumpThread {
        private LoggingPump(String threadName, LogRecordBuffer buffer) {
            super(threadName, buffer);
        }

        @Override
        protected boolean isShutdownRequested() {
            return !GlassFishLogHandler.this.configuration.isEnabled() || !GlassFishLogHandler.this.isReady();
        }

        @Override
        protected int getFlushFrequency() {
            return GlassFishLogHandler.this.configuration.getFlushFrequency();
        }

        @Override
        protected boolean logRecord(GlassFishLogRecord record) {
            return GlassFishLogHandler.this.publishRecord(record);
        }

        @Override
        protected void flushOutput() {
            GlassFishLogHandler.this.flush();
        }
    }
}

