/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;

public final class DomainDirs {
    private final ServerDirs dirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainDirs.class);

    public DomainDirs() throws IOException {
        this(null, null);
    }

    public DomainDirs(File domainsDir, String domainName) throws IOException {
        if (domainsDir == null) {
            domainsDir = DomainDirs.getDefaultDomainsDir();
        }
        if (!domainsDir.isDirectory()) {
            throw new IOException(strings.get("Domain.badDomainsDir", domainsDir));
        }
        File domainDir = domainName != null ? new File(domainsDir, domainName) : this.getTheOneAndOnlyDir(domainsDir);
        if (!domainDir.isDirectory()) {
            throw new IOException(strings.get("Domain.badDomainDir", domainDir));
        }
        this.dirs = new ServerDirs(domainDir);
    }

    public DomainDirs(File domainDir) throws IOException {
        this.dirs = new ServerDirs(domainDir);
    }

    public DomainDirs(ServerDirs sd) {
        this.dirs = sd;
    }

    public String toString() {
        return this.dirs.toString();
    }

    public final String getDomainName() {
        return this.dirs.getServerName();
    }

    public final File getDomainDir() {
        return this.dirs.getServerDir();
    }

    public final File getDomainsDir() {
        return this.dirs.getServerParentDir();
    }

    public final ServerDirs getServerDirs() {
        return this.dirs;
    }

    public final boolean isValid() {
        try {
            return this.dirs.isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getDefaultDomainsDir() throws IOException {
        Map<String, String> systemProps = new ASenvPropertyReader().getProps();
        String defDomains = systemProps.get("com.sun.aas.domainsRoot");
        if (defDomains == null) {
            throw new IOException(strings.get("Domain.noDomainsDir", "com.sun.aas.domainsRoot"));
        }
        return new File(defDomains);
    }

    private File getTheOneAndOnlyDir(File parent) throws IOException {
        File[] files = parent.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                File config = new File(f, "config");
                File dxml = new File(config, "domain.xml");
                return f.isDirectory() && config.isDirectory() && dxml.isFile();
            }
        });
        if (files == null || files.length == 0) {
            throw new IOException(strings.get("Domain.noDomainDirs", parent));
        }
        if (files.length > 1) {
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < files.length; ++i) {
                if (i > 0) {
                    names.append(", ");
                }
                names.append(files[i].getName());
            }
            throw new IOException(strings.get("Domain.tooManyDomainDirs", parent, names.toString()));
        }
        return files[0];
    }
}

