/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class QualifierAnnotationProxy
implements InvocationHandler {
    private final int hashCode;
    private final List<Method> methods;
    private final Class<?> qualifierClass;
    private final String stringValue;

    public QualifierAnnotationProxy(Class<?> qualifierClass) {
        this.qualifierClass = qualifierClass;
        String qualifierClassName = qualifierClass.getName();
        this.methods = new ArrayList<Method>();
        int hash = qualifierClassName.hashCode();
        StringBuilder stringValueBuf = new StringBuilder().append('@').append(qualifierClassName).append('(');
        boolean first = true;
        for (Method method : qualifierClass.getMethods()) {
            int hashIncr;
            String name;
            if (method.getParameterCount() != 0 || "annotationType".equals(name = method.getName()) || "hashCode".equals(name) || "toString".equals(name)) continue;
            this.methods.add(method);
            Object value = method.getDefaultValue();
            if (first) {
                first = false;
            } else {
                stringValueBuf.append(", ");
            }
            stringValueBuf.append(name).append('=');
            if (value instanceof Object[]) {
                array = (Object[])value;
                hashIncr = Arrays.hashCode(array);
                stringValueBuf.append(Arrays.toString(array));
            } else if (value instanceof int[]) {
                array = (int[])value;
                hashIncr = Arrays.hashCode((int[])array);
                stringValueBuf.append(Arrays.toString((int[])array));
            } else if (value instanceof long[]) {
                array = (long[])value;
                hashIncr = Arrays.hashCode((long[])array);
                stringValueBuf.append(Arrays.toString((long[])array));
            } else if (value instanceof boolean[]) {
                array = (boolean[])value;
                hashIncr = Arrays.hashCode((boolean[])array);
                stringValueBuf.append(Arrays.toString((boolean[])array));
            } else if (value instanceof double[]) {
                array = (double[])value;
                hashIncr = Arrays.hashCode((double[])array);
                stringValueBuf.append(Arrays.toString((double[])array));
            } else if (value instanceof float[]) {
                array = (float[])value;
                hashIncr = Arrays.hashCode((float[])array);
                stringValueBuf.append(Arrays.toString((float[])array));
            } else if (value instanceof short[]) {
                array = (short[])value;
                hashIncr = Arrays.hashCode((short[])array);
                stringValueBuf.append(Arrays.toString((short[])array));
            } else if (value instanceof byte[]) {
                array = (byte[])value;
                hashIncr = Arrays.hashCode((byte[])array);
                stringValueBuf.append(Arrays.toString((byte[])array));
            } else if (value instanceof char[]) {
                array = (char[])value;
                hashIncr = Arrays.hashCode((char[])array);
                stringValueBuf.append(Arrays.toString((char[])array));
            } else if (value != null) {
                hashIncr = value.hashCode();
                stringValueBuf.append(value);
            } else {
                hashIncr = "null".hashCode();
                stringValueBuf.append("null");
            }
            hash += 127 * name.hashCode() ^ hashIncr;
        }
        this.stringValue = stringValueBuf.append(")[QualifierProxy]").toString();
        this.hashCode = hash;
    }

    private boolean equals(Object proxy, Object other) throws Exception {
        boolean equal;
        if (proxy == other) {
            equal = true;
        } else if (this.qualifierClass.isInstance(other)) {
            InvocationHandler otherHandler;
            boolean isProxy = Proxy.isProxyClass(other.getClass());
            InvocationHandler invocationHandler = otherHandler = isProxy ? Proxy.getInvocationHandler(other) : null;
            if (otherHandler instanceof QualifierAnnotationProxy) {
                equal = ((QualifierAnnotationProxy)otherHandler).qualifierClass.equals(this.qualifierClass);
            } else {
                equal = true;
                for (Method method : this.methods) {
                    Object value1 = method.getDefaultValue();
                    Object value2 = method.invoke(other, new Object[0]);
                    equal = value1 instanceof Object[] ? Arrays.equals((Object[])value1, (Object[])value2) : (value1 instanceof int[] ? Arrays.equals((int[])value1, (int[])value2) : (value1 instanceof long[] ? Arrays.equals((long[])value1, (long[])value2) : (value1 instanceof boolean[] ? Arrays.equals((boolean[])value1, (boolean[])value2) : (value1 instanceof double[] ? Arrays.equals((double[])value1, (double[])value2) : (value1 instanceof float[] ? Arrays.equals((float[])value1, (float[])value2) : (value1 instanceof short[] ? Arrays.equals((short[])value1, (short[])value2) : (value1 instanceof byte[] ? Arrays.equals((byte[])value1, (byte[])value2) : (value1 instanceof char[] ? Arrays.equals((char[])value1, (char[])value2) : Objects.equals(value1, value2)))))))));
                    if (equal) continue;
                    break;
                }
            }
        } else {
            equal = false;
        }
        return equal;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int numParams = method.getParameterCount();
        if (numParams == 0 && "hashCode".equals(methodName)) {
            return this.hashCode;
        }
        if (numParams == 0 && "toString".equals(methodName)) {
            return this.stringValue;
        }
        if (numParams == 0 && "annotationType".equals(methodName)) {
            return this.qualifierClass;
        }
        if (numParams == 1 && "equals".equals(methodName)) {
            return this.equals(proxy, args[0]);
        }
        return method.getDefaultValue();
    }
}

