/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.Map;
import java.util.Properties;

public class MultiLruCache
extends BaseCache {
    public static final int LRU_HEAD = 0;
    public static final int LRU_TAIL = 1;
    public static final int DEFAULT_HASHTABLE_SEGMENT_SIZE = 4096;
    int segmentSize;
    LruCacheItem[][] lists;
    protected int[] listsLength;
    int trimCount;
    int trimIndex;
    Object trimIndexLk = new Object();

    @Override
    public void init(int maxCapacity, Properties props) throws Exception {
        String prop;
        super.init(maxCapacity, props);
        this.segmentSize = 4096;
        if (props != null && (prop = props.getProperty("MultiLRUSegmentSize")) != null) {
            try {
                this.segmentSize = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int segments = this.maxBuckets / this.segmentSize + (this.maxBuckets % this.segmentSize != 0 ? 1 : 0);
        this.lists = new LruCacheItem[segments][2];
        this.listsLength = new int[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i][0] = null;
            this.lists[i][1] = null;
            this.listsLength[i] = 0;
        }
    }

    @Override
    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new LruCacheItem(hashCode, key, value, size);
    }

    protected BaseCache.CacheItem trimLru(int segment) {
        LruCacheItem[] list = this.lists[segment];
        LruCacheItem l = null;
        l = list[1];
        list[1] = l.lPrev;
        list[1].lNext = null;
        l.lPrev = null;
        int n = segment;
        this.listsLength[n] = this.listsLength[n] - 1;
        l.isTrimmed = true;
        ++this.trimCount;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        LruCacheItem[] list;
        BaseCache.CacheItem overflow = null;
        if (!(item instanceof LruCacheItem)) {
            return null;
        }
        LruCacheItem lc = (LruCacheItem)item;
        int index = this.getIndex(item.hashCode());
        int segment = index / this.segmentSize;
        LruCacheItem[] lruCacheItemArray = list = this.lists[segment];
        synchronized (list) {
            if (list[0] != null) {
                list[0].lPrev = lc;
                lc.lNext = list[0];
            } else {
                list[1] = lc;
            }
            list[0] = lc;
            int n = segment;
            this.listsLength[n] = this.listsLength[n] + 1;
            if (this.isThresholdReached()) {
                overflow = this.trimLru(this.trimIndex);
                this.incrementTrimIndex();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return overflow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemAccessed(BaseCache.CacheItem item) {
        int index = this.getIndex(item.hashCode());
        int segment = index / this.segmentSize;
        LruCacheItem[] list = this.lists[segment];
        if (!(item instanceof LruCacheItem)) {
            return;
        }
        LruCacheItem lc = (LruCacheItem)item;
        LruCacheItem[] lruCacheItemArray = list;
        synchronized (list) {
            LruCacheItem prev = lc.lPrev;
            LruCacheItem next = lc.lNext;
            if (prev != null) {
                lc.lPrev = null;
                lc.lNext = list[0];
                list[0].lPrev = lc;
                list[0] = lc;
                prev.lNext = next;
                if (next != null) {
                    next.lPrev = prev;
                } else {
                    list[1] = prev;
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        this.itemAccessed(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemRemoved(BaseCache.CacheItem item) {
        LruCacheItem[] list;
        if (!(item instanceof LruCacheItem)) {
            return;
        }
        LruCacheItem l = (LruCacheItem)item;
        int index = this.getIndex(item.hashCode());
        int segment = index / this.segmentSize;
        LruCacheItem[] lruCacheItemArray = list = this.lists[segment];
        synchronized (list) {
            if (l.isTrimmed) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            LruCacheItem prev = l.lPrev;
            LruCacheItem next = l.lNext;
            if (prev != null) {
                prev.lNext = next;
            } else {
                list[0] = next;
            }
            if (next != null) {
                next.lPrev = prev;
            } else {
                list[1] = prev;
            }
            int n = segment;
            this.listsLength[n] = this.listsLength[n] - 1;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void handleOverflow() {
    }

    int getListsLength() {
        return this.lists.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementTrimIndex() {
        Object object = this.trimIndexLk;
        synchronized (object) {
            this.trimIndex = (this.trimIndex + 1) % this.lists.length;
        }
    }

    @Override
    public Object getStatByName(String key) {
        Integer[] stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.MultiLruCache.stat_segmentSize")) {
                stat = this.segmentSize;
            } else if (key.equals("cache.MultiLruCache.stat_trimCount")) {
                stat = this.trimCount;
            } else if (key.equals("cache.MultiLruCache.stat_segmentListLength")) {
                stat = new Integer[this.lists.length];
                for (int i = 0; i < this.lists.length; ++i) {
                    stat[i] = this.listsLength[i];
                }
            }
        }
        return stat;
    }

    @Override
    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.MultiLruCache.stat_segmentSize", this.segmentSize);
        for (int i = 0; i < this.lists.length; ++i) {
            stats.put("cache.MultiLruCache.stat_segmentListLength[" + i + "]:", this.listsLength[i]);
        }
        stats.put("cache.MultiLruCache.stat_trimCount", this.trimCount);
        return stats;
    }

    static class LruCacheItem
    extends BaseCache.CacheItem {
        LruCacheItem lNext;
        LruCacheItem lPrev;
        boolean isTrimmed;

        LruCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
        }
    }
}

