/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.SFSBTxCheckpointCoordinator;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.config.EjbContainerAvailability;

final class ContainerSynchronization
implements Synchronization {
    private static final Logger _logger = LogDomains.getLogger(ContainerSynchronization.class, (String)"jakarta.enterprise.system.container.ejb");
    private ArrayList beans = new ArrayList();
    private Vector pmSyncs = new Vector();
    private Hashtable timerSyncs = new Hashtable();
    private Transaction tx;
    private EjbContainerUtil ejbContainerUtilImpl;
    SFSBTxCheckpointCoordinator sfsbTxCoordinator;

    ContainerSynchronization(Transaction tx, EjbContainerUtil ejbContainerUtilImpl) {
        this.tx = tx;
        this.ejbContainerUtilImpl = ejbContainerUtilImpl;
    }

    Vector getBeanList() {
        Vector vec = new Vector();
        Iterator iter = this.beans.iterator();
        while (iter.hasNext()) {
            vec.add(iter.next());
        }
        return vec;
    }

    void addBean(EJBContextImpl bean) {
        this.beans.add(bean);
    }

    void removeBean(EJBContextImpl bean) {
        this.beans.remove(bean);
    }

    void addPMSynchronization(Synchronization sync) {
        this.pmSyncs.add(sync);
    }

    void addTimerSynchronization(TimerPrimaryKey timerId, Synchronization sync) {
        this.timerSyncs.put(timerId, sync);
    }

    Synchronization getTimerSynchronization(TimerPrimaryKey timerId) {
        return (Synchronization)this.timerSyncs.get(timerId);
    }

    void removeTimerSynchronization(TimerPrimaryKey timerId) {
        this.timerSyncs.remove(timerId);
    }

    @Override
    public void beforeCompletion() {
        int i;
        for (i = 0; i < this.beans.size(); ++i) {
            EJBContextImpl context = (EJBContextImpl)this.beans.get(i);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                if (container != null) {
                    boolean allowTxCompletion = true;
                    if (container.isUndeployed()) {
                        if (context instanceof SessionContextImpl) {
                            allowTxCompletion = ((SessionContextImpl)context).getInLifeCycleCallback();
                        } else {
                            allowTxCompletion = false;
                            _logger.log(Level.WARNING, "Marking Tx for rollback  because container for " + String.valueOf(container) + " is undeployed");
                        }
                    }
                    if (!allowTxCompletion) {
                        try {
                            this.tx.setRollbackOnly();
                        }
                        catch (SystemException sysEx) {
                            _logger.log(Level.FINE, "Error while trying to mark for rollback", sysEx);
                        }
                        continue;
                    }
                    container.beforeCompletion(context);
                    continue;
                }
                _logger.log(Level.FINE, "context with empty container in  ContainerSynchronization.beforeCompletion");
                continue;
            }
            catch (RuntimeException ex) {
                this.logAndRollbackTransaction(ex);
                throw ex;
            }
            catch (Exception ex) {
                this.logAndRollbackTransaction(ex);
                throw new EJBException("Error during beforeCompletion.", ex);
            }
        }
        for (i = 0; i < this.pmSyncs.size(); ++i) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i);
            try {
                sync.beforeCompletion();
                continue;
            }
            catch (RuntimeException ex) {
                this.logAndRollbackTransaction(ex);
                throw ex;
            }
            catch (Exception ex) {
                this.logAndRollbackTransaction(ex);
                throw new EJBException("Error during beforeCompletion.", ex);
            }
        }
    }

    private void logAndRollbackTransaction(Exception ex) {
        _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", ex);
        try {
            this.tx.setRollbackOnly();
        }
        catch (SystemException e) {
            _logger.log(Level.FINE, "", ex);
        }
    }

    @Override
    public void afterCompletion(int status) {
        int i;
        for (i = 0; i < this.pmSyncs.size(); ++i) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i);
            try {
                sync.afterCompletion(status);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        for (i = 0; i < this.beans.size(); ++i) {
            EJBContextImpl context = (EJBContextImpl)this.beans.get(i);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                if (container != null) {
                    container.afterCompletion(context, status);
                    continue;
                }
                _logger.log(Level.FINE, "context with empty container in  ContainerSynchronization.afterCompletion");
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        if (this.sfsbTxCoordinator != null) {
            this.sfsbTxCoordinator.doTxCheckpoint();
        }
        for (Synchronization timerSync : this.timerSyncs.values()) {
            try {
                timerSync.afterCompletion(status);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "ejb.after_completion_error", ex);
            }
        }
        this.ejbContainerUtilImpl.removeContainerSync(this.tx);
    }

    void registerForTxCheckpoint(SessionContextImpl sessionCtx) {
        if (this.sfsbTxCoordinator == null) {
            String sfsbHaPersistenceTypeFromConfig = "jdbc/hastore";
            EjbContainerAvailability ejbContainerAvailability = (EjbContainerAvailability)this.ejbContainerUtilImpl.getServices().getService(EjbContainerAvailability.class, new Annotation[0]);
            if (ejbContainerAvailability != null) {
                sfsbHaPersistenceTypeFromConfig = ejbContainerAvailability.getSfsbStorePoolName();
            }
            this.sfsbTxCoordinator = new SFSBTxCheckpointCoordinator(sfsbHaPersistenceTypeFromConfig);
        }
        this.sfsbTxCoordinator.registerContext(sessionCtx);
    }
}

