/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.resource.pool.PoolSize;
import java.util.Hashtable;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class UnpooledResource
extends ConnectionPool {
    private PoolSize poolSize;

    public UnpooledResource(PoolInfo poolInfo, Hashtable env) throws PoolingException {
        super(poolInfo, env);
        this.failAllConnections = false;
    }

    @Override
    protected synchronized void initPool(ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.poolSize = new PoolSize(this.maxPoolSize);
        this.poolInitialized = true;
    }

    @Override
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc) {
        return null;
    }

    @Override
    protected void reconfigureSteadyPoolSize(int oldSteadyPoolSize, int newSteadyPoolSize) throws PoolingException {
    }

    @Override
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc) throws PoolingException {
        ResourceHandle handle;
        this.poolSize.increment();
        try {
            handle = this.createSingleResource(alloc);
        }
        catch (PoolingException | RuntimeException ex) {
            this.poolSize.decrement();
            throw ex;
        }
        handle.getResourceState().reset();
        this.setResourceStateToBusy(handle);
        return handle;
    }

    @Override
    public void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        this.freeUnenlistedResource(resourceHandle);
    }

    @Override
    protected void freeUnenlistedResource(ResourceHandle resourceHandle) {
        this.poolSize.decrement();
        this.deleteResource(resourceHandle);
    }
}

