/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.util.Vector;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;

public class NCInterfaceType
extends InterfaceType {
    public static NCInterfaceType forNCInterface(ClassDefinition classDef, ContextStack stack) {
        if (stack.anyErrors()) {
            return null;
        }
        boolean doPop = false;
        try {
            org.glassfish.rmic.tools.java.Type theType = classDef.getType();
            Type existing = NCInterfaceType.getType(theType, stack);
            if (existing != null) {
                if (!(existing instanceof NCInterfaceType)) {
                    return null;
                }
                return (NCInterfaceType)existing;
            }
            NCInterfaceType it = new NCInterfaceType(stack, classDef);
            NCInterfaceType.putType(theType, (Type)it, stack);
            stack.push(it);
            doPop = true;
            if (it.initialize(stack)) {
                stack.pop(true);
                return it;
            }
            NCInterfaceType.removeType(theType, stack);
            stack.pop(false);
            return null;
        }
        catch (CompilerError e) {
            if (doPop) {
                stack.pop(false);
            }
            return null;
        }
    }

    @Override
    public String getTypeDescription() {
        return "Non-conforming interface";
    }

    private NCInterfaceType(ContextStack stack, ClassDefinition classDef) {
        super(stack, classDef, 0xA004000);
    }

    private boolean initialize(ContextStack stack) {
        if (stack.getEnv().getParseNonConforming()) {
            Vector<InterfaceType> directInterfaces = new Vector<InterfaceType>();
            Vector<CompoundType.Method> directMethods = new Vector<CompoundType.Method>();
            Vector<CompoundType.Member> directMembers = new Vector<CompoundType.Member>();
            try {
                this.addNonRemoteInterfaces(directInterfaces, stack);
                return this.addAllMethods(this.getClassDefinition(), directMethods, false, false, stack) == null || !this.addConformingConstants(directMembers, false, stack) || this.initialize(directInterfaces, directMethods, directMembers, stack, false);
            }
            catch (ClassNotFound e) {
                NCInterfaceType.classNotFound(stack, e);
                return false;
            }
        }
        return this.initialize(null, null, null, stack, false);
    }
}

