/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

public class PacketUtil {
    public static void dumpBody(PrintStream os, int pType, InputStream is, int bodySize, Hashtable props) {
        os.print("   Message Body: " + bodySize + " bytes ");
        if (is == null) {
            os.println();
            os.flush();
            return;
        }
        switch (pType) {
            case 24: 
            case 32: {
                SysMessageID id = new SysMessageID();
                int n = bodySize / 40;
                try {
                    Integer idType = null;
                    if (props != null) {
                        idType = (Integer)props.get("JMQBodyType");
                    }
                    DataInputStream dis = new DataInputStream(is);
                    while (n > 0) {
                        if (idType == null || idType == 2) {
                            os.print("[" + dis.readLong() + ":");
                        } else {
                            os.print("[" + dis.readInt() + ":");
                        }
                        id.readID(dis);
                        os.print(String.valueOf(id) + "]");
                        --n;
                    }
                    dis.close();
                }
                catch (Exception e) {
                    os.println("Exception when reading packet body: " + String.valueOf(e));
                }
                break;
            }
            case 1: {
                int n = bodySize;
                if (n > 40) {
                    n = 40;
                }
                byte[] buf = new byte[40];
                try {
                    is.read(buf);
                    os.print("[" + new String(buf));
                    if (n < bodySize) {
                        os.print(". . .");
                    }
                    os.print("]");
                }
                catch (IOException e) {
                    os.println("Exception when reading packet body: " + String.valueOf(e));
                }
                break;
            }
            case 3: 
            case 5: {
                try {
                    FilteringObjectInputStream ois = new FilteringObjectInputStream(is);
                    Object o = ois.readObject();
                    String s = o.toString();
                    if (s.length() > 512) {
                        os.println(s.substring(0, 512) + ". . .");
                    } else {
                        os.println(s);
                    }
                    ois.close();
                }
                catch (Exception e) {
                    os.println("Exception when deserializing packet body: " + String.valueOf(e));
                }
                break;
            }
            case 12: {
                try {
                    String type = (String)props.get("JMQAuthType");
                    os.print(type + ": ");
                    DataInputStream dis = new DataInputStream(is);
                    if (type.equals("basic")) {
                        String username = dis.readUTF();
                        String password = dis.readUTF();
                        os.print("username=" + username + ", password=" + password);
                        break;
                    }
                    if (type.equals("digest")) {
                        String username = dis.readUTF();
                        String password = dis.readUTF();
                        os.print("username=" + username + ", password=" + password);
                        break;
                    }
                    os.print("Unknown authentication type");
                }
                catch (Exception e) {
                    os.println("Exception when reading packet body: " + String.valueOf(e));
                }
                break;
            }
            case 61: {
                try {
                    Integer quantity = (Integer)props.get("JMQQuantity");
                    int n = 0;
                    if (quantity != null) {
                        n = quantity;
                    }
                    DataInputStream dis = new DataInputStream(is);
                    while (n > 0) {
                        JMQXid xid = JMQXid.read(dis);
                        os.println("[XID=" + String.valueOf(xid) + "], ");
                        --n;
                    }
                    break;
                }
                catch (IOException e) {
                    os.println("Could not decode XIDs: " + String.valueOf(e));
                    break;
                }
            }
            case 73: {
                try {
                    FilteringObjectInputStream dis = new FilteringObjectInputStream(is);
                    Hashtable ht = (Hashtable)dis.readObject();
                    for (Map.Entry mEntry : ht.entrySet()) {
                        Object key = mEntry.getKey();
                        Object value = mEntry.getValue();
                        if (value instanceof Hashtable) {
                            os.println("\tTable: " + String.valueOf(key));
                            for (Map.Entry mEntry1 : ((Hashtable)value).entrySet()) {
                                Object key1 = mEntry1.getKey();
                                Object value1 = mEntry1.getValue();
                                os.println("\t\t" + String.valueOf(key1) + "=" + String.valueOf(value1));
                            }
                            continue;
                        }
                        os.println("\t" + String.valueOf(key) + "=" + String.valueOf(value));
                    }
                    break;
                }
                catch (Exception e) {
                    os.println("Could not decode INFO packet: " + String.valueOf(e));
                    break;
                }
            }
            case 44: 
            case 46: 
            case 48: 
            case 56: 
            case 58: 
            case 60: {
                try {
                    JMQXid xid = JMQXid.read(new DataInputStream(is));
                    os.println("[XID=" + String.valueOf(xid) + "]");
                }
                catch (IOException e) {
                    os.println("Could not decode XID: " + String.valueOf(e));
                }
                break;
            }
            case 79: {
                try {
                    FilteringObjectInputStream oos = new FilteringObjectInputStream(is);
                    Object newo = oos.readObject();
                    os.println(newo);
                    break;
                }
                catch (Exception e) {
                    os.println("Could not decode verify body: " + String.valueOf(e));
                }
            }
        }
        os.println();
        os.flush();
    }

    public static String dumpThrowable(Throwable thr) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            thr.printStackTrace(ps);
            ps.flush();
            bos.flush();
            String str = bos.toString();
            ps.close();
            bos.close();
            return str;
        }
        catch (Exception ex) {
            return "Exception dumping exception " + String.valueOf(ex);
        }
    }

    public static String dumpPacket(Packet pkt) {
        return PacketUtil.dumpPacket(pkt, "\t");
    }

    public static String dumpPacket(Packet pkt, String prefix) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            pkt.dump(ps, prefix);
            ps.flush();
            bos.flush();
            String str = bos.toString();
            ps.close();
            bos.close();
            return str;
        }
        catch (Exception ex) {
            return "Exception dumping packet " + String.valueOf(ex);
        }
    }
}

