/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.annotation.handlers;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.http.HttpServlet;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.security.common.Role;
import org.glassfish.web.deployment.annotation.handlers.AbstractWebHandler;
import org.glassfish.web.deployment.descriptor.AuthorizationConstraintImpl;
import org.glassfish.web.deployment.descriptor.SecurityConstraintImpl;
import org.glassfish.web.deployment.descriptor.UserDataConstraintImpl;
import org.glassfish.web.deployment.descriptor.WebResourceCollectionImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ServletSecurity.class)
public class ServletSecurityHandler
extends AbstractWebHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletSecurityHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        WebComponentContext webCompContext;
        HandlerProcessingResult result = null;
        WebComponentContext[] webComponentContextArray = webCompContexts;
        int n = webComponentContextArray.length;
        for (int i = 0; i < n && (result = this.processAnnotation(ainfo, (webCompContext = webComponentContextArray[i]).getDescriptor())).getOverallResult() != ResultType.FAILED; ++i) {
        }
        return result;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getWebAnnotationTypes();
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentDescriptor webCompDesc) throws AnnotationProcessorException {
        Class webCompClass = (Class)ainfo.getAnnotatedElement();
        if (!HttpServlet.class.isAssignableFrom(webCompClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("web.deployment.annotation.handlers.needtoextend", "The Class {0} having annotation {1} need to be a derived class of {2}.", new Object[]{webCompClass.getName(), SecurityConstraint.class.getName(), HttpServlet.class.getName()}));
            return this.getDefaultFailedResult();
        }
        Set<String> urlPatterns = ServletSecurityHandler.getUrlPatternsWithoutSecurityConstraint(webCompDesc);
        if (urlPatterns.size() > 0) {
            HttpMethodConstraint[] httpMethodConstraints;
            WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
            ServletSecurity servletSecurityAn = (ServletSecurity)ainfo.getAnnotation();
            for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraints = servletSecurityAn.httpMethodConstraints()) {
                String httpMethod = httpMethodConstraint.value();
                if (httpMethod == null || httpMethod.length() == 0) {
                    return this.getDefaultFailedResult();
                }
                ServletSecurityHandler.createSecurityConstraint(webBundleDesc, urlPatterns, httpMethodConstraint.rolesAllowed(), httpMethodConstraint.emptyRoleSemantic(), httpMethodConstraint.transportGuarantee(), httpMethod);
            }
            HttpConstraint httpConstraint = servletSecurityAn.value();
            boolean isDefault = ServletSecurityHandler.isDefaultHttpConstraint(httpConstraint);
            if (isDefault && httpMethodConstraints.length > 0 && logger.isLoggable(Level.FINER)) {
                StringBuilder methodString = new StringBuilder();
                for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraints) {
                    methodString.append(" ");
                    methodString.append(httpMethodConstraint.value());
                }
                for (String pattern : urlPatterns) {
                    logger.finer("Pattern: " + pattern + " assumes default unprotected configuration for all methods except:" + methodString);
                }
            }
            if (!isDefault || httpMethodConstraints.length == 0) {
                SecurityConstraint securityConstraint = ServletSecurityHandler.createSecurityConstraint(webBundleDesc, urlPatterns, httpConstraint.rolesAllowed(), httpConstraint.value(), httpConstraint.transportGuarantee(), null);
                WebResourceCollection webResColl = (WebResourceCollection)securityConstraint.getWebResourceCollections().iterator().next();
                for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraints) {
                    webResColl.addHttpMethodOmission(httpMethodConstraint.value());
                }
            }
        }
        return this.getDefaultProcessedResult();
    }

    private static boolean isDefaultHttpConstraint(HttpConstraint httpConstraint) {
        return httpConstraint.value() == ServletSecurity.EmptyRoleSemantic.PERMIT && (httpConstraint.rolesAllowed() == null || httpConstraint.rolesAllowed().length == 0) && httpConstraint.transportGuarantee() == ServletSecurity.TransportGuarantee.NONE;
    }

    public static Set<String> getUrlPatternsWithoutSecurityConstraint(WebComponentDescriptor webCompDesc) {
        HashSet<String> urlPatternsWithoutSC = new HashSet<String>(webCompDesc.getUrlPatternsSet());
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        for (SecurityConstraint sc : webBundleDesc.getSecurityConstraints()) {
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                urlPatternsWithoutSC.removeAll(wrc.getUrlPatterns());
            }
        }
        return urlPatternsWithoutSC;
    }

    public static SecurityConstraint createSecurityConstraint(WebBundleDescriptor webBundleDesc, Set<String> urlPatterns, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, ServletSecurity.TransportGuarantee transportGuarantee, String httpMethod) {
        SecurityConstraintImpl securityConstraint = new SecurityConstraintImpl();
        WebResourceCollectionImpl webResourceColl = new WebResourceCollectionImpl();
        securityConstraint.addWebResourceCollection(webResourceColl);
        for (String string : urlPatterns) {
            webResourceColl.addUrlPattern(string);
        }
        AuthorizationConstraintImpl ac = null;
        if (rolesAllowed != null && rolesAllowed.length > 0) {
            if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.annotation.handlers.denyWithRolesAllowed", "One cannot specify DENY with an non-empty array of rolesAllowed in @ServletSecurity / ServletSecurityElement"));
            }
            ac = new AuthorizationConstraintImpl();
            for (String roleName : rolesAllowed) {
                Role role = new Role(roleName);
                webBundleDesc.addRole(role);
                ac.addSecurityRole(roleName);
            }
        } else if (emptyRoleSemantic != ServletSecurity.EmptyRoleSemantic.PERMIT) {
            ac = new AuthorizationConstraintImpl();
        }
        securityConstraint.setAuthorizationConstraint(ac);
        UserDataConstraintImpl userDataConstraintImpl = new UserDataConstraintImpl();
        userDataConstraintImpl.setTransportGuarantee(transportGuarantee == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? "CONFIDENTIAL" : "NONE");
        securityConstraint.setUserDataConstraint(userDataConstraintImpl);
        if (httpMethod != null) {
            webResourceColl.addHttpMethod(httpMethod);
        }
        webBundleDesc.addSecurityConstraint((SecurityConstraint)securityConstraint);
        return securityConstraint;
    }
}

