/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.util;

import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.LogFacade;
import org.glassfish.ejb.deployment.descriptor.DummyEjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.InterceptorBindingDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;
import org.glassfish.ejb.deployment.util.EjbVisitor;
import org.glassfish.ejb.deployment.util.InterceptorBindingTranslator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.AnnotationTypesProvider;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.common.Role;

public class EjbBundleValidator
extends ComponentValidator
implements EjbBundleVisitor,
EjbVisitor {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(EjbBundleValidator.class);
    private static final Logger LOG = LogFacade.getLogger();
    @LogMessageInfo(message="Passivation-capable value of stateful session bean [{0}] is false, it should not have any PrePassivate nor PostActivate configuration, but you have configuration at [{1}].", level="WARNING")
    private static final String REDUNDANT_PASSIVATION_CALLBACK_METADATA = "AS-EJB-00048";
    protected EjbBundleDescriptorImpl ejbBundleDescriptor;
    protected EjbDescriptor ejb;

    public void accept(BundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        this.application = descriptor.getApplication();
        if (descriptor instanceof EjbBundleDescriptorImpl) {
            EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)descriptor;
            this.accept(ejbBundle);
            for (EjbDescriptor ejbDescriptor : ejbBundle.getEjbs()) {
                ejbDescriptor.visit(this.getSubDescriptorVisitor((Descriptor)ejbDescriptor));
            }
            if (ejbBundle.hasRelationships()) {
                for (Object object : ejbBundle.getRelationships()) {
                    RelationshipDescriptor rd = (RelationshipDescriptor)((Object)object);
                    this.accept(rd);
                }
            }
            for (WebService webService : ejbBundle.getWebServices().getWebServices()) {
                this.accept(webService);
            }
            for (InjectionCapable injectionCapable : ejbBundle.getInjectableResources((JndiNameEnvironment)ejbBundle)) {
                this.accept(injectionCapable);
            }
        }
        super.accept(descriptor);
    }

    public void accept(EjbBundleDescriptor bundleDesc) {
        this.application = bundleDesc.getApplication();
        EjbBundleDescriptorImpl bundle = (EjbBundleDescriptorImpl)bundleDesc;
        if (bundle.getEjbs().isEmpty()) {
            throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.util.no_ejb_in_ejb_jar", "Invalid ejb jar {0}: it contains zero ejb. A valid ejb jar requires at least one session/entity/message driven bean.", new Object[]{bundle.getModuleDescriptor().getArchiveUri()}));
        }
        if (!this.areResourceReferencesValid(bundle)) {
            throw new RuntimeException("Incorrectly resolved role references");
        }
        this.ejbBundleDescriptor = bundle;
        this.handleOverloadedInterceptorMethodBindings(bundle);
        InterceptorBindingTranslator bindingTranslator = new InterceptorBindingTranslator(bundle);
        for (EjbDescriptor ejb0 : bundle.getEjbs()) {
            if (ejb0.isRemoteInterfacesSupported() && (ejb0.getRemoteClassName() == null || ejb0.getRemoteClassName().isBlank())) {
                throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.util.componentInterfaceMissing", "{0} Component interface is missing in EJB [{1}]", new Object[]{"Remote", ejb0.getName()}));
            }
            if (ejb0.isLocalInterfacesSupported() && (ejb0.getLocalClassName() == null || ejb0.getLocalClassName().isBlank())) {
                throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.util.componentInterfaceMissing", "{0} Component interface is missing in EJB [{1}]", new Object[]{"Local", ejb0.getName()}));
            }
            if ("Entity".equals(ejb0.getType())) continue;
            ejb0.applyInterceptors(bindingTranslator);
        }
    }

    private boolean areResourceReferencesValid(EjbBundleDescriptorImpl bundle) {
        for (EjbDescriptor ejbDescriptor : bundle.getEjbs()) {
            for (RoleReference reference : ejbDescriptor.getRoleReferences()) {
                Role referredRole = reference.getRole();
                Set roles = bundle.getRoles();
                if (referredRole.getName().isEmpty() || roles.contains(referredRole)) continue;
                LOG.log(Level.WARNING, "Bad role reference to {0}, roles: {1}", new Object[]{referredRole, roles});
                return false;
            }
        }
        return true;
    }

    private void handleOverloadedInterceptorMethodBindings(EjbBundleDescriptorImpl bundleDesc) {
        List<InterceptorBindingDescriptor> origBindings = bundleDesc.getInterceptorBindings();
        if (origBindings.isEmpty()) {
            return;
        }
        ClassLoader cl = bundleDesc.getClassLoader();
        ArrayList<InterceptorBindingDescriptor> newBindings = new ArrayList<InterceptorBindingDescriptor>();
        for (InterceptorBindingDescriptor next : origBindings) {
            if (!next.getNeedsOverloadResolution()) {
                newBindings.add(next);
                continue;
            }
            MethodDescriptor overloadedMethodDesc = next.getBusinessMethod();
            String methodName = overloadedMethodDesc.getName();
            String ejbName = next.getEjbName();
            EjbDescriptor ejbDesc = bundleDesc.getEjbByName(ejbName);
            Class<?> ejbClass = null;
            try {
                ejbClass = cl.loadClass(ejbDesc.getEjbClassName());
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading ejb class " + ejbDesc.getEjbClassName(), e);
            }
            boolean isMethod = false;
            for (Method ejbClassMethod : ejbClass.getDeclaredMethods()) {
                if (!ejbClassMethod.getName().equals(methodName)) continue;
                isMethod = true;
                InterceptorBindingDescriptor newInterceptorBinding = new InterceptorBindingDescriptor();
                MethodDescriptor newMethodDesc = new MethodDescriptor(ejbClassMethod, "Bean");
                newInterceptorBinding.setEjbName(ejbName);
                newInterceptorBinding.setBusinessMethod(newMethodDesc);
                for (String interceptorClass : next.getInterceptorClasses()) {
                    newInterceptorBinding.appendInterceptorClass(interceptorClass);
                }
                newInterceptorBinding.setIsTotalOrdering(next.getIsTotalOrdering());
                newInterceptorBinding.setExcludeDefaultInterceptors(next.getExcludeDefaultInterceptors());
                newInterceptorBinding.setExcludeClassInterceptors(next.getExcludeClassInterceptors());
                newBindings.add(newInterceptorBinding);
            }
            if (isMethod || !methodName.equals(ejbClass.getSimpleName())) continue;
            newBindings.add(next);
        }
        bundleDesc.setInterceptorBindings(newBindings);
    }

    @Override
    public void accept(EjbDescriptor ejb) {
        MessageDestinationReferencer msgDestReferencer;
        if (ejb instanceof DummyEjbDescriptor) {
            throw new IllegalArgumentException("Referencing error: this bundle has no bean of name: " + ejb.getName());
        }
        this.ejb = ejb;
        this.setDOLDefault(ejb);
        this.computeRuntimeDefault(ejb);
        this.checkDependsOn(ejb);
        this.validateConcurrencyMetadata(ejb);
        this.validateStatefulTimeout(ejb);
        this.validatePassivationConfiguration(ejb);
        try {
            ClassLoader cl = ejb.getEjbBundleDescriptor().getClassLoader();
            Class<?> ejbClass = cl.loadClass(ejb.getEjbClassName());
            if (Globals.getDefaultHabitat() == null) {
                return;
            }
            AnnotationTypesProvider provider = (AnnotationTypesProvider)Globals.getDefaultHabitat().getService(AnnotationTypesProvider.class, "EJB", new Annotation[0]);
            if (provider == null) {
                throw new IllegalStateException("Cannot find AnnotationTypesProvider named 'EJB'");
            }
            if (ejb.getEjbTimeoutMethod() == null && provider.getType("jakarta.ejb.TimedObject").isAssignableFrom(ejbClass)) {
                MethodDescriptor timedObjectMethod = new MethodDescriptor("ejbTimeout", "TimedObject timeout method", new String[]{"jakarta.ejb.Timer"}, "Timer");
                ejb.setEjbTimeoutMethod(timedObjectMethod);
            } else if (ejb.getEjbTimeoutMethod() != null) {
                MethodDescriptor timeoutMethodDescOrig = ejb.getEjbTimeoutMethod();
                MethodDescriptor timeoutMethodDesc = this.processTimeoutMethod(ejb, timeoutMethodDescOrig, provider, ejbClass);
                ejb.setEjbTimeoutMethod(timeoutMethodDesc);
            }
            for (ScheduledTimerDescriptor sd : ejb.getScheduledTimerDescriptors()) {
                try {
                    EJBTimerSchedule.isValid(sd);
                }
                catch (Exception e) {
                    throw new RuntimeException(ejb.getName() + ": Invalid schedule defined on method " + sd.getTimeoutMethod().getFormattedString() + ": " + e.getMessage());
                }
                MethodDescriptor timeoutMethodDescOrig = sd.getTimeoutMethod();
                MethodDescriptor timeoutMethodDesc = this.processTimeoutMethod(ejb, timeoutMethodDescOrig, provider, ejbClass);
                sd.setTimeoutMethod(timeoutMethodDesc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing EjbDescriptor", e);
        }
        for (InjectionCapable injectable : ejb.getEjbBundleDescriptor().getInjectableResources((JndiNameEnvironment)ejb)) {
            this.accept(injectable);
        }
        for (EjbReference aRef : ejb.getEjbReferenceDescriptors()) {
            this.accept(aRef);
        }
        for (Object element : ejb.getResourceReferenceDescriptors()) {
            this.accept((ResourceReferenceDescriptor)element);
        }
        for (Object element : ejb.getResourceEnvReferenceDescriptors()) {
            this.accept((ResourceEnvReferenceDescriptor)element);
        }
        for (Object element : ejb.getMessageDestinationReferenceDescriptors()) {
            this.accept((MessageDestinationReferencer)element);
        }
        if (ejb.getType().equals("Message-driven") && ejb instanceof MessageDestinationReferencer && (msgDestReferencer = (MessageDestinationReferencer)ejb).getMessageDestinationLinkName() != null) {
            this.accept(msgDestReferencer);
        }
        Set serviceRefs = ejb.getServiceReferenceDescriptors();
        for (ServiceReferenceDescriptor serviceRef : serviceRefs) {
            this.accept(serviceRef);
        }
        if (ejb instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor cmp = (EjbCMPEntityDescriptor)ejb;
            PersistenceDescriptor persistenceDesc = cmp.getPersistenceDescriptor();
            for (FieldDescriptor element : persistenceDesc.getCMPFields()) {
                this.accept(element);
            }
        }
    }

    public void accept(WebService webService) {
    }

    private void validateConcurrencyMetadata(EjbDescriptor ejb) {
        if (ejb instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejb;
            List<EjbSessionDescriptor.AccessTimeoutHolder> accessTimeoutInfo = sessionDesc.getAccessTimeoutInfo();
            for (EjbSessionDescriptor.AccessTimeoutHolder accessTimeoutHolder : accessTimeoutInfo) {
                MethodDescriptor accessTimeoutMethodDesc = accessTimeoutHolder.method;
                Method accessTimeoutMethod = accessTimeoutMethodDesc.getMethod((com.sun.enterprise.deployment.EjbDescriptor)ejb);
                if (accessTimeoutMethod != null) continue;
                throw new RuntimeException("Invalid AccessTimeout method signature " + accessTimeoutMethodDesc + " . Method could not be resolved to a bean class method for bean " + ejb.getName());
            }
            for (MethodDescriptor lockMethodDesc : sessionDesc.getReadAndWriteLockMethods()) {
                Method readLockMethod = lockMethodDesc.getMethod((com.sun.enterprise.deployment.EjbDescriptor)sessionDesc);
                if (readLockMethod != null) continue;
                throw new RuntimeException("Invalid Lock method signature " + lockMethodDesc + " . Method could not be resolved to a bean class method for bean " + ejb.getName());
            }
        }
    }

    private void validateStatefulTimeout(EjbDescriptor ejb) {
        EjbSessionDescriptor sessionDesc;
        Long statefulTimeoutValue;
        if (ejb instanceof EjbSessionDescriptor && (statefulTimeoutValue = (sessionDesc = (EjbSessionDescriptor)ejb).getStatefulTimeoutValue()) != null && statefulTimeoutValue < -1L) {
            throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.invalid_stateful_timeout_value", "Invalid value [{0}] for @StatefulTimeout or <stateful-timeout> element in EJB [{1}]. Values less than -1 are not valid.", new Object[]{statefulTimeoutValue, sessionDesc.getName()}));
        }
    }

    private void validatePassivationConfiguration(EjbDescriptor ejb) {
        if (ejb instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejb;
            if (!sessionDesc.isStateful() || sessionDesc.isPassivationCapable()) {
                return;
            }
            String callbackInfo = this.getAllPrePassivatePostActivateCallbackInfo(sessionDesc);
            if (callbackInfo.length() > 0) {
                LOG.log(Level.WARNING, REDUNDANT_PASSIVATION_CALLBACK_METADATA, new Object[]{ejb.getName(), callbackInfo});
            }
        }
    }

    private String getAllPrePassivatePostActivateCallbackInfo(EjbSessionDescriptor sessionDesc) {
        ArrayList<LifecycleCallbackDescriptor> descriptors = new ArrayList<LifecycleCallbackDescriptor>();
        descriptors.addAll(sessionDesc.getPrePassivateDescriptors());
        descriptors.addAll(sessionDesc.getPostActivateDescriptors());
        for (EjbInterceptor interceptor : sessionDesc.getInterceptorClasses()) {
            descriptors.addAll(interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE));
            descriptors.addAll(interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE));
        }
        StringBuilder result = new StringBuilder();
        for (LifecycleCallbackDescriptor each : descriptors) {
            result.append(each.getLifecycleCallbackClass());
            result.append(".");
            result.append(each.getLifecycleCallbackMethod());
            result.append(", ");
        }
        if (result.length() > 2) {
            return result.substring(0, result.length() - 2);
        }
        return result.toString();
    }

    private void checkDependsOn(EjbDescriptor ejb) {
        EjbSessionDescriptor sessionDesc;
        if (ejb instanceof EjbSessionDescriptor && (sessionDesc = (EjbSessionDescriptor)ejb).hasDependsOn()) {
            String[] dependsOn;
            if (!sessionDesc.isSingleton()) {
                throw new RuntimeException("Illegal usage of DependsOn for EJB " + ejb.getName() + ". DependsOn is only supported for Singleton beans");
            }
            for (String next : dependsOn = sessionDesc.getDependsOn()) {
                boolean fullyQualified = next.contains("#");
                EjbBundleDescriptorImpl sessionEjbBundleDescriptor = sessionDesc.getEjbBundleDescriptor();
                Application app = sessionEjbBundleDescriptor.getApplication();
                if (fullyQualified) {
                    EjbBundleDescriptorImpl ejbBundle;
                    int indexOfHash = next.indexOf("#");
                    String ejbName = next.substring(indexOfHash + 1);
                    String relativeJarPath = next.substring(0, indexOfHash);
                    BundleDescriptor bundle = app.getRelativeBundle((BundleDescriptor)sessionEjbBundleDescriptor, relativeJarPath);
                    if (bundle == null) {
                        throw new IllegalStateException("Invalid @DependOn value = " + next + " for Singleton " + sessionDesc.getName());
                    }
                    EjbBundleDescriptorImpl ejbBundleDescriptorImpl = ejbBundle = bundle.getModuleType() == null || !bundle.getModuleType().equals((Object)DOLUtils.warType()) ? (EjbBundleDescriptorImpl)bundle : (EjbBundleDescriptorImpl)((Object)bundle.getExtensionsDescriptors(EjbBundleDescriptorImpl.class).iterator().next());
                    if (ejbBundle.hasEjbByName(ejbName)) continue;
                    throw new RuntimeException("Invalid DependsOn dependency '" + next + "' for EJB " + ejb.getName());
                }
                EjbBundleDescriptorImpl bundle = ejb.getEjbBundleDescriptor();
                if (bundle.hasEjbByName(next)) continue;
                throw new RuntimeException("Invalid DependsOn dependency '" + next + "' for EJB " + ejb.getName());
            }
        }
    }

    protected EjbBundleDescriptorImpl getEjbBundleDescriptor() {
        return this.ejbBundleDescriptor;
    }

    protected EjbDescriptor getEjbDescriptor() {
        return this.ejb;
    }

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.ejbBundleDescriptor;
    }

    private void setDOLDefault(EjbDescriptor ejb) {
        if (ejb.getUsesCallerIdentity() == null) {
            if (ejb instanceof EjbMessageBeanDescriptor) {
                ejb.setUsesCallerIdentity(false);
            } else {
                ejb.setUsesCallerIdentity(true);
            }
        }
        if (ejb.getTransactionType() == null) {
            ejb.setTransactionType("Container");
        }
        ejb.setUsesDefaultTransaction();
    }

    private void computeRuntimeDefault(EjbDescriptor ejb) {
        String intfName = null;
        if (!(ejb.getJndiName() != null && !ejb.getJndiName().isEmpty() || ejb.isRemoteInterfacesSupported() && ejb.isRemoteBusinessInterfacesSupported())) {
            Set classNames;
            if (ejb.isRemoteInterfacesSupported()) {
                intfName = ejb.getHomeClassName();
            } else if (ejb.isRemoteBusinessInterfacesSupported() && (classNames = ejb.getRemoteBusinessClassNames()).size() == 1) {
                intfName = (String)classNames.iterator().next();
            }
        }
        if (intfName != null) {
            ejb.setJndiName(SimpleJndiName.of(intfName));
        }
        if (Boolean.FALSE.equals(ejb.getUsesCallerIdentity())) {
            this.computeRunAsPrincipalDefault(ejb.getRunAsIdentity(), ejb.getApplication());
        }
    }

    private MethodDescriptor processTimeoutMethod(EjbDescriptor ejb, MethodDescriptor timeoutMethodDescOrig, AnnotationTypesProvider provider, Class<?> ejbClass) throws ClassNotFoundException {
        Method m = timeoutMethodDescOrig.getDeclaredMethod((com.sun.enterprise.deployment.EjbDescriptor)ejb);
        if (m == null) {
            Class[] params = new Class[]{provider.getType("jakarta.ejb.Timer")};
            m = timeoutMethodDescOrig.getDeclaredMethod((com.sun.enterprise.deployment.EjbDescriptor)ejb, params);
        }
        if (m == null) {
            throw new RuntimeException("Class " + ejbClass.getName() + " does not define timeout method " + timeoutMethodDescOrig.getFormattedString());
        }
        return new MethodDescriptor(m, "Timer");
    }
}

