/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.appserv.connectors.internal.api.WorkManagerFactory;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEventListener;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ActiveRAFactory;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntimeExtension;
import com.sun.enterprise.connectors.XATerminatorProxy;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.connectors.deployment.util.ConnectorArchivist;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.service.ConnectorAdminObjectAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConfigurationParserServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.service.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.util.ConnectorConfigParser;
import com.sun.enterprise.connectors.util.ConnectorConfigParserFactory;
import com.sun.enterprise.connectors.util.ConnectorJavaBeanValidator;
import com.sun.enterprise.connectors.util.ConnectorTimerProxy;
import com.sun.enterprise.connectors.util.DriverLoader;
import com.sun.enterprise.connectors.util.RAWriterAdapter;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.resource.deployer.MailSessionDeployer;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProviderUtil;
import com.sun.enterprise.resource.pool.monitor.PoolMonitoringLevelListener;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.ee.jmac.callback.ContainerCallbackHandler;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.admin.monitor.MonitoringBootstrap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.listener.ResourceManager;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resources.api.ResourcesRegistry;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class ConnectorRuntime
implements com.sun.appserv.connectors.internal.api.ConnectorRuntime,
PostConstruct,
PreDestroy {
    private static ConnectorRuntime _runtime;
    private final Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private ConnectorService connectorService;
    private ConnectorConfigurationParserServiceImpl configParserAdmService;
    private ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private ConnectorAdminObjectAdminServiceImpl adminObjectAdminService;
    private final ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
    private PoolMonitoringLevelListener poolMonitoringLevelListener;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private PoolManager poolManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private Provider<JavaEETransactionManager> javaEETransactionManagerProvider;
    @Inject
    private Provider<WorkManagerFactory> workManagerFactoryProvider;
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<ApplicationRegistry> applicationRegistryProvider;
    @Inject
    private Provider<ApplicationArchivist> applicationArchivistProvider;
    @Inject
    private Provider<FileArchive> fileArchiveProvider;
    @Inject
    private Provider<SecurityRoleMapperFactory> securityRoleMapperFactoryProvider;
    @Inject
    private Provider<SecurityServicesUtil> securityServicesUtilProvider;
    @Inject
    private Provider<ContainerCallbackHandler> containerCallbackHandlerProvider;
    @Inject
    private Provider<ArchivistFactory> archivistFactoryProvider;
    @Inject
    private Provider<WorkContextHandler> workContextHandlerProvider;
    @Inject
    private Provider<MailSessionDeployer> mailSessionDeployerProvider;
    @Inject
    @Named(value="default-instance-name")
    private Provider<org.glassfish.connectors.config.ConnectorService> connectorServiceProvider;
    @Inject
    private Provider<Applications> applicationsProvider;
    @Inject
    private ClassLoaderHierarchy classLoaderHierarchy;
    @Inject
    private ConnectorsClassLoaderUtil connectorsClassLoaderUtil;
    @Inject
    private ActiveRAFactory activeRAFactory;
    @Inject
    private Provider<ConnectionPoolProbeProviderUtil> connectionPoolProbeProviderUtilProvider;
    @Inject
    private Provider<MonitoringBootstrap> monitoringBootstrapProvider;
    @Inject
    private Provider<PoolMonitoringLevelListener> poolMonitoringLevelListenerProvider;
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private Provider<ResourceManager> resourceManagerProvider;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private DriverLoader driverLoader;
    @Inject
    private ConnectorJavaBeanValidator connectorBeanValidator;
    @Inject
    private ConnectorClassLoaderService connectorClassLoaderService;
    @Inject
    private ServerEnvironmentImpl serverEnvironmentImpl;
    @Inject
    private ResourceNamingService resourceNamingService;
    @Inject
    private RarType archiveType;
    @Inject
    private ServiceLocator serviceLocator;
    private Resources globalResources;
    private ResourceManager resourceManager;
    private JavaEETransactionManager transactionManager;
    private ProcessEnvironment.ProcessType processType;

    public static ConnectorRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("Connector Runtime not initialized");
        }
        return _runtime;
    }

    public ConnectorRuntime() {
        _runtime = this;
    }

    public ConnectionPoolProbeProviderUtil getProbeProviderUtil() {
        return (ConnectionPoolProbeProviderUtil)this.connectionPoolProbeProviderUtilProvider.get();
    }

    public ResourceNamingService getResourceNamingService() {
        return this.resourceNamingService;
    }

    public ProcessEnvironment.ProcessType getEnvironment() {
        return this.processType;
    }

    public MonitoringBootstrap getMonitoringBootstrap() {
        return (MonitoringBootstrap)this.monitoringBootstrapProvider.get();
    }

    public SimpleJndiName getDefaultPoolName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public void deleteConnectorConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolInfo);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorResource(ResourceInfo resourceInfo, PoolInfo poolInfo, String resourceType) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.createConnectorResource(resourceInfo, poolInfo, resourceType);
    }

    public SimpleJndiName getDefaultResourceName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public PrintWriter getResourceAdapterLogWriter() {
        Logger logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"jakarta.enterprise.resource.resourceadapter");
        return new PrintWriter(new RAWriterAdapter(logger));
    }

    public void deleteConnectorResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.deleteConnectorResource(resourceInfo);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return this.connectorService.getConnectorDescriptor(rarName);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName, ClassLoader loader) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName, loader);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir, ClassLoader loader) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, loader);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, null);
    }

    public void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.stopActiveResourceAdapter(moduleName);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo, Hashtable env) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo, env);
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactories(poolInfo);
    }

    public ConnectionManager obtainConnectionManager(PoolInfo poolInfo, boolean forceNoLazyAssoc, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        return ConnectionManagerFactory.getAvailableConnectionManager(poolInfo, forceNoLazyAssoc, resourceInfo);
    }

    public <T> T lookupPMResource(ResourceInfo resourceInfo, boolean force) throws NamingException {
        ResourceInfo ri;
        if (resourceInfo.getName().hasSuffix("__pm")) {
            ri = resourceInfo;
        } else {
            SimpleJndiName jndiName = SimpleJndiName.of((String)(resourceInfo.getName() + "__pm"));
            ri = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        }
        try {
            return this.connectorResourceAdmService.lookup(ri);
        }
        catch (NamingException ne) {
            if (force && this.isDAS()) {
                this._logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", ri);
                return this.lookupDataSourceInDAS(ri);
            }
            throw ne;
        }
    }

    public <T> T lookupPMResource(SimpleJndiName jndiName, boolean force) throws NamingException {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName);
        return this.lookupPMResource(resourceInfo, force);
    }

    public <T> T lookupNonTxResource(SimpleJndiName jndiName, boolean force) throws NamingException {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName);
        return this.lookupNonTxResource(resourceInfo, force);
    }

    public <T> T lookupNonTxResource(ResourceInfo resourceInfo, boolean force) throws NamingException {
        ResourceInfo ri;
        if (resourceInfo.getName().hasSuffix("__nontx")) {
            ri = resourceInfo;
        } else {
            SimpleJndiName jndiName = SimpleJndiName.of((String)(resourceInfo.getName() + "__nontx"));
            ri = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        }
        try {
            return this.connectorResourceAdmService.lookup(ri);
        }
        catch (NamingException ne) {
            if (force && this.isDAS()) {
                this._logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", ri);
                return this.lookupDataSourceInDAS(ri);
            }
            throw ne;
        }
    }

    private boolean isDAS() {
        return this.serverEnvironmentImpl.isDas();
    }

    private <T> T lookupDataSourceInDAS(ResourceInfo resourceInfo) {
        try {
            List extensions = this.serviceLocator.getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
            Iterator iterator = extensions.iterator();
            if (iterator.hasNext()) {
                ConnectorRuntimeExtension extension = (ConnectorRuntimeExtension)iterator.next();
                return extension.lookupDataSourceInDAS(resourceInfo);
            }
            return null;
        }
        catch (ConnectorRuntimeException cre) {
            throw new RuntimeException(cre.getMessage(), cre);
        }
    }

    public Connection getConnection(ResourceInfo resourceInfo, String user, String password) throws SQLException {
        return this.ccPoolAdmService.getConnection(resourceInfo, user, password);
    }

    public Connection getConnection(ResourceInfo resourceInfo) throws SQLException {
        return this.ccPoolAdmService.getConnection(resourceInfo);
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName, String resType) {
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName, resType);
    }

    public Map<String, String> getBuiltInCustomResources() {
        return ConnectorsUtil.getBuiltInCustomResources();
    }

    public String[] getSystemConnectorsAllowingPoolCreation() {
        ArrayList<String> validSystemRarsAllowingPoolCreation = new ArrayList<String>();
        Collection validSystemRars = ConnectorsUtil.getSystemRARs();
        for (String systemRarName : systemRarsAllowingPoolCreation) {
            if (!validSystemRars.contains(systemRarName)) continue;
            validSystemRarsAllowingPoolCreation.add(systemRarName);
        }
        return validSystemRarsAllowingPoolCreation.toArray(new String[validSystemRarsAllowingPoolCreation.size()]);
    }

    public String[] getConnectionDefinitionNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getConnectionDefinitionNames(rarName);
    }

    public String getSecurityPermissionSpec(String moduleName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getSecurityPermissionSpec(moduleName);
    }

    public String[] getAdminObjectInterfaceNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getAdminObjectInterfaceNames(rarName);
    }

    public String[] getAdminObjectClassNames(String rarName, String intfName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getAdminObjectClassNames(rarName, intfName);
    }

    public boolean hasAdminObject(String rarName, String intfName, String className) throws ConnectorRuntimeException {
        return this.configParserAdmService.hasAdminObject(rarName, intfName, className);
    }

    public Map<String, String> getResourceAdapterConfigProps(String rarName) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getResourceAdapterConfigProps(rarName);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getMCFConfigProps(String rarName, String connectionDefName) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMCFConfigProps(rarName, connectionDefName);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getAdminObjectConfigProps(String rarName, String adminObjectIntf) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getAdminObjectConfigProps(String rarName, String adminObjectIntf, String adminObjectClass) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf, adminObjectClass);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getConnectorConfigJavaBeans(rarName, connectionDefName, type);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public String getActivationSpecClass(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return this.configParserAdmService.getActivationSpecClass(rarName, messageListenerType);
    }

    public String[] getMessageListenerTypes(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getMessageListenerTypes(rarName);
    }

    public Map<String, String> getMessageListenerConfigProps(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMessageListenerConfigProps(rarName, messageListenerType);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getMessageListenerConfigPropTypes(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMessageListenerConfigPropTypes(rarName, messageListenerType);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public void switchOnMatching(String rarName, PoolInfo poolInfo) {
        this.connectorService.switchOnMatching(rarName, poolInfo);
    }

    public void switchOnMatchingInJndi(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.ccPoolAdmService.switchOnMatching(poolInfo);
    }

    public GlassfishNamingManager getNamingManager() {
        return this.namingManager;
    }

    public void postConstruct() {
        this.ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        this.connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        this.connectorService = new ConnectorService();
        this.resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        this.connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        this.adminObjectAdminService = (ConnectorAdminObjectAdminServiceImpl)ConnectorAdminServicesFactory.getService("AdminObjectResource");
        this.configParserAdmService = new ConnectorConfigurationParserServiceImpl();
        this.initializeEnvironment(this.processEnvironment);
        if (this.isServer()) {
            this.getProbeProviderUtil().registerProbeProvider();
        }
        if (this.isServer() || this.isEmbedded()) {
            this.poolMonitoringLevelListener = (PoolMonitoringLevelListener)this.poolMonitoringLevelListenerProvider.get();
            this.getResourceManager();
        }
    }

    private void initializeEnvironment(ProcessEnvironment processEnvironment) {
        this.processType = processEnvironment.getProcessType();
    }

    public boolean isConnectorConnectionPoolDeployed(PoolInfo poolInfo) {
        return this.ccPoolAdmService.isConnectorConnectionPoolDeployed(poolInfo);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        this.ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    private synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            try {
                this.resourceManager = (ResourceManager)this.resourceManagerProvider.get();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.resourceManager;
    }

    public void cleanUpResourcesAndShutdownAllActiveRAs() {
        ResourceManager rm;
        Domain domain = (Domain)this.domainProvider.get();
        if (domain != null && (rm = this.getResourceManager()) != null) {
            Collection<Resource> resources = ConnectorsUtil.getAllSystemRAResourcesAndPools((Resources)domain.getResources());
            this.resourceManager.undeployResources((Collection)resources);
            resources = null;
            List extensions = this.serviceLocator.getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
            for (ConnectorRuntimeExtension extension : extensions) {
                resources = extension.getAllSystemRAResourcesAndPools();
                this.resourceManager.undeployResources(resources);
            }
        }
        this.poolManager.killFreeConnectionsInPools();
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public void shutdownAllActiveResourceAdapters() {
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    public InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public Timer getTimer() {
        return ConnectorTimerProxy.getProxy();
    }

    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptor() {
        JndiNameEnvironment jndiEnv = this.componentEnvManager.getCurrentJndiNameEnvironment();
        return jndiEnv == null ? null : jndiEnv.getResourceReferenceDescriptors();
    }

    public void preDestroy() {
    }

    public AuthenticationService getAuthenticationService(String rarName, PoolInfo poolInfo) {
        return this.connectorSecurityAdmService.getAuthenticationService(rarName, poolInfo);
    }

    public boolean isEmbedded() {
        return ProcessEnvironment.ProcessType.Embedded.equals((Object)this.processType);
    }

    public boolean isNonACCRuntime() {
        return ProcessEnvironment.ProcessType.Other.equals((Object)this.processType);
    }

    public boolean isServer() {
        return ProcessEnvironment.ProcessType.Server.equals((Object)this.processType);
    }

    public boolean isACCRuntime() {
        return ProcessEnvironment.ProcessType.ACC.equals((Object)this.processType);
    }

    public Transaction getTransaction() throws SystemException {
        return this.getTransactionManager().getTransaction();
    }

    public JavaEETransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (JavaEETransactionManager)this.javaEETransactionManagerProvider.get();
        }
        return this.transactionManager;
    }

    public void registerConnectorNamingEventListener(ConnectorNamingEventListener listener) {
        this.connectorResourceAdmService.getResourceRebindEventNotifier().addListener(listener);
    }

    public void unregisterConnectorNamingEventListener(ConnectorNamingEventListener listener) {
        this.connectorResourceAdmService.getResourceRebindEventNotifier().removeListener(listener);
    }

    public ResourcePool getConnectionPoolConfig(PoolInfo poolInfo) {
        Resources asc;
        this._logger.log(Level.FINEST, "getConnectionPoolConfig(poolInfo={0})", poolInfo);
        ResourcePool pool = ResourcesUtil.createInstance().getPoolConfig(poolInfo);
        if (pool != null) {
            return pool;
        }
        if ((ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)poolInfo) || ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)poolInfo)) && (pool = ConnectorsUtil.getConnectionPoolConfig((PoolInfo)poolInfo, (Resources)(asc = ResourcesRegistry.getResources((String)poolInfo.getApplicationName(), (String)poolInfo.getModuleName())))) != null) {
            return pool;
        }
        return null;
    }

    public boolean pingConnectionPool(PoolInfo poolInfo) throws ResourceException {
        return this.ccPoolAdmService.testConnectionPool(poolInfo);
    }

    public ConnectorConstants.PoolType getPoolType(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.getPoolType(poolInfo);
    }

    public WorkManager getWorkManagerProxy(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        return ((WorkManagerFactory)this.workManagerFactoryProvider.get()).getWorkManagerProxy(poolId, moduleName, rarCL);
    }

    public XATerminator getXATerminatorProxy(String moduleName) {
        XATerminator xat = this.getTransactionManager().getXATerminator();
        return new XATerminatorProxy(xat);
    }

    public void removeWorkManagerProxy(String moduleName) {
        ((WorkManagerFactory)this.workManagerFactoryProvider.get()).removeWorkManager(moduleName);
    }

    public void addAdminObject(String appName, String connectorName, ResourceInfo resourceInfo, String adminObjectType, String adminObjectClassName, Properties props) throws ConnectorRuntimeException {
        this.adminObjectAdminService.addAdminObject(appName, connectorName, resourceInfo, adminObjectType, adminObjectClassName, props);
    }

    public void deleteAdminObject(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        this.adminObjectAdminService.deleteAdminObject(resourceInfo);
    }

    public ClassLoader getSystemRARClassLoader(String rarName) throws ConnectorRuntimeException {
        return this.connectorsClassLoaderUtil.getSystemRARClassLoader(rarName);
    }

    public ClassLoader createConnectorClassLoader(String moduleDirectory, ClassLoader parent, String rarModuleName) throws ConnectorRuntimeException {
        List libraries = ConnectorsUtil.getInstalledLibrariesFromManifest((String)moduleDirectory, (ServerEnvironment)this.serverEnvironmentImpl);
        return this.connectorsClassLoaderUtil.createRARClassLoader(moduleDirectory, parent, rarModuleName, libraries);
    }

    public ResourceDeployer getResourceDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.addResourceAdapterConfig(rarName, raConfig);
    }

    public void deleteResourceAdapterConfig(String rarName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.deleteResourceAdapterConfig(rarName);
    }

    public void registerConnectorApplication(ConnectorApplication rarModule) {
        this.connectorRegistry.addConnectorApplication(rarModule);
    }

    public void unregisterConnectorApplication(String rarName) {
        this.connectorRegistry.removeConnectorApplication(rarName);
    }

    public void undeployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.undeployResources();
    }

    public void deployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.deployResources();
    }

    public ActiveRAFactory getActiveRAFactory() {
        return this.activeRAFactory;
    }

    public Applications getApplications() {
        return (Applications)this.applicationsProvider.get();
    }

    public ApplicationRegistry getAppRegistry() {
        return (ApplicationRegistry)this.applicationRegistryProvider.get();
    }

    public ApplicationArchivist getApplicationArchivist() {
        return (ApplicationArchivist)this.applicationArchivistProvider.get();
    }

    public FileArchive getFileArchive() {
        return (FileArchive)this.fileArchiveProvider.get();
    }

    public Domain getDomain() {
        return (Domain)this.domainProvider.get();
    }

    public ServerEnvironment getServerEnvironment() {
        return this.serverEnvironmentImpl;
    }

    public void createActiveResourceAdapterForEmbeddedRar(String rarModuleName) throws ConnectorRuntimeException {
        this.connectorService.createActiveResourceAdapterForEmbeddedRar(rarModuleName);
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        return this.connectorService.checkAccessibility(rarName, loader);
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        this.connectorService.loadDeferredResourceAdapter(rarName);
    }

    public SecurityRoleMapperFactory getSecurityRoleMapperFactory() {
        return (SecurityRoleMapperFactory)this.securityRoleMapperFactoryProvider.get();
    }

    public CallbackHandler getCallbackHandler() {
        this.securityServicesUtilProvider.get();
        return (CallbackHandler)this.containerCallbackHandlerProvider.get();
    }

    public ConnectorArchivist getConnectorArchvist() throws ConnectorRuntimeException {
        ArchivistFactory archivistFactory = (ArchivistFactory)this.archivistFactoryProvider.get();
        return (ConnectorArchivist)archivistFactory.getArchivist((ArchiveType)this.archiveType);
    }

    public WorkContextHandler getWorkContextHandler() {
        return (WorkContextHandler)this.workContextHandlerProvider.get();
    }

    public ComponentEnvManager getComponentEnvManager() {
        return this.componentEnvManager;
    }

    public DelegatingClassLoader getConnectorClassLoader() {
        return this.classLoaderHierarchy.getConnectorClassLoader(null);
    }

    public ClassLoaderHierarchy getClassLoaderHierarchy() {
        return this.classLoaderHierarchy;
    }

    public void registerDataSourceDefinitions(Application application) {
        for (ConnectorRuntimeExtension extension : this.serviceLocator.getAllServices(ConnectorRuntimeExtension.class, new Annotation[0])) {
            extension.registerDataSourceDefinitions(application);
        }
    }

    public void unRegisterDataSourceDefinitions(Application application) {
        for (ConnectorRuntimeExtension extension : this.serviceLocator.getAllServices(ConnectorRuntimeExtension.class, new Annotation[0])) {
            extension.unRegisterDataSourceDefinitions(application);
        }
    }

    public void registerMailSessions(Application application) {
        ((MailSessionDeployer)this.mailSessionDeployerProvider.get()).registerMailSessions(application);
    }

    public void unRegisterMailSessions(Application application) {
        ((MailSessionDeployer)this.mailSessionDeployerProvider.get()).unRegisterMailSessions(application);
    }

    public List<WorkSecurityMap> getWorkSecurityMap(String raName) {
        List workSecurityMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)this.getResources());
        List appScopedMap = null;
        String appName = raName;
        if (!ConnectorsUtil.isStandAloneRA((String)raName)) {
            Resources msr;
            String resourceAdapterName;
            Module module;
            appName = ConnectorsUtil.getApplicationNameOfEmbeddedRar((String)raName);
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(appName);
            if (application != null && (module = application.getModule(resourceAdapterName = ConnectorsUtil.getRarNameFromApplication((String)raName))) != null && (msr = module.getResources()) != null) {
                appScopedMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)msr);
            }
        } else {
            Resources asc;
            com.sun.enterprise.config.serverbeans.Application app = this.getApplications().getApplication(appName);
            if (app != null && (asc = app.getResources()) != null) {
                appScopedMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)asc);
            }
        }
        if (appScopedMap != null) {
            workSecurityMap.addAll(appScopedMap);
        }
        return workSecurityMap;
    }

    public Resources getResources(PoolInfo poolInfo) {
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)poolInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(poolInfo.getApplicationName());
            if (application == null) {
                return null;
            }
            return application.getModule(poolInfo.getModuleName()).getResources();
        }
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)poolInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(poolInfo.getApplicationName());
            if (application == null) {
                return null;
            }
            return application.getResources();
        }
        return this.getResources();
    }

    public Resources getResources(ResourceInfo resourceInfo) {
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo)) {
            return this.getApplications().getApplication(resourceInfo.getApplicationName()).getModule(resourceInfo.getModuleName()).getResources();
        }
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo)) {
            return this.getApplications().getApplication(resourceInfo.getApplicationName()).getResources();
        }
        return this.getResources();
    }

    public Resources getResources() {
        if (this.globalResources == null) {
            this.globalResources = ((Domain)this.domainProvider.get()).getResources();
        }
        return this.globalResources;
    }

    public long getShutdownTimeout() {
        return ConnectorsUtil.getShutdownTimeout((org.glassfish.connectors.config.ConnectorService)((org.glassfish.connectors.config.ConnectorService)this.connectorServiceProvider.get()));
    }

    public boolean flushConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.flushConnectionPool(poolInfo);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType) {
        return this.driverLoader.getJdbcDriverClassNames(dbVendor, resType);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        return this.driverLoader.getJdbcDriverClassNames(dbVendor, resType, introspect);
    }

    public ConnectorJavaBeanValidator getConnectorBeanValidator() {
        return this.connectorBeanValidator;
    }

    public boolean getPingDuringPoolCreation(PoolInfo poolInfo) {
        return ConnectorsUtil.getPingDuringPoolCreation((PoolInfo)poolInfo, (Resources)this.getResources(poolInfo));
    }

    public Set<String> getDatabaseVendorNames() {
        return this.driverLoader.getDatabaseVendorNames();
    }

    public boolean isJdbcPoolMonitoringEnabled() {
        boolean enabled = false;
        if (this.poolMonitoringLevelListener != null) {
            enabled = this.poolMonitoringLevelListener.getJdbcPoolMonitoringEnabled();
        }
        return enabled;
    }

    public boolean isConnectorPoolMonitoringEnabled() {
        boolean enabled = false;
        if (this.poolMonitoringLevelListener != null) {
            enabled = this.poolMonitoringLevelListener.getConnectorPoolMonitoringEnabled();
        }
        return enabled;
    }

    public void associateResourceAdapter(String rarName, ResourceAdapterAssociation raa) throws ResourceException {
        this.resourceAdapterAdmService.associateResourceAdapter(rarName, raa);
    }

    public ResourceManager getGlobalResourceManager() {
        return this.getResourceManager();
    }

    public List<String> getConfidentialProperties(String rarName, String type, String ... keyFields) throws ConnectorRuntimeException {
        ConnectorConfigParser configParser = ConnectorConfigParserFactory.getParser(type);
        if (configParser == null) {
            throw new ConnectorRuntimeException("Invalid type : " + type);
        }
        return configParser.getConfidentialProperties(this.getConnectorDescriptor(rarName), rarName, keyFields);
    }
}

