/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.impl.ServerSentEventApplication;
import org.glassfish.sse.impl.ServerSentEventCdiExtension;
import org.glassfish.sse.impl.ServerSentEventConnectionImpl;

@WebServlet(asyncSupported=true)
public final class ServerSentEventServlet
extends HttpServlet {
    private static final long serialVersionUID = -2281462213280496518L;
    @Inject
    private transient ServerSentEventCdiExtension extension;
    @Inject
    private transient BeanManager beanManager;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.extension == null) {
            throw new RuntimeException("Enable CDI by including empty WEB-INF/beans.xml");
        }
        Map<String, ServerSentEventApplication> applicationMap = this.extension.getApplicationMap();
        ServerSentEventApplication sseApp = applicationMap.get(request.getServletPath());
        Class<?> clazz = sseApp.getHandlerClass();
        Iterator it = this.beanManager.getBeans(clazz, new Annotation[0]).iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("Cannot create ServerSentEventHandler using CDI");
        }
        Bean bean = (Bean)it.next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        ServerSentEventHandler serverSentEventHandler = (ServerSentEventHandler)bean.create(creationalContext);
        ServerSentEventHandler.Status status = serverSentEventHandler.onConnecting(request);
        if (status == ServerSentEventHandler.Status.DONT_RECONNECT) {
            response.setStatus(204);
            creationalContext.release();
            return;
        }
        if (status != ServerSentEventHandler.Status.OK) {
            throw new RuntimeException("Internal Error: need to handle status " + status);
        }
        response.setStatus(200);
        response.setContentType("text/event-stream");
        response.flushBuffer();
        AsyncContext asyncContext = request.startAsync(request, response);
        asyncContext.setTimeout(0L);
        ServerSentEventConnectionImpl sseConnection = sseApp.createConnection(request, serverSentEventHandler, creationalContext, asyncContext);
        asyncContext.addListener(sseConnection);
        sseConnection.init();
    }
}

