/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.relationaloperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.TestNum;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeOperandsIT {
    private static final System.Logger logger = System.getLogger(DateTimeOperandsIT.class.getName());
    private List<Object> dateTimeList = Collections.unmodifiableList(TestNum.getDateTimeList());

    @Test
    public void elDateTest() throws Exception {
        this.doTypeTest(x -> Date.from(x));
    }

    @Test
    public void elClockTest() throws Exception {
        this.doTypeTest(x -> Clock.fixed(x, ZoneId.of("Z")));
    }

    @Test
    public void elInstantTest() throws Exception {
        this.doTypeTest(x -> x);
    }

    @Test
    public void elTemporalTest() throws Exception {
        this.doTypeTest(x -> ZonedDateTime.ofInstant(x, ZoneId.of("+12:00")));
    }

    @Test
    public void elStringTest() throws Exception {
        this.doTypeTest(x -> x.toString());
    }

    private void doTypeTest(InstantToObject converter) {
        this.doEqualToTest(converter);
        this.doNotEqualToTest(converter);
        this.doLessThanTest(converter);
        this.doLessThanOrEqualTest(converter);
        this.doGreaterThanOrEqualTest(converter);
        this.doGreaterThanTest(converter);
    }

    private void doEqualToTest(InstantToObject converter) {
        this.doTest(converter, List.of("==", "eq"), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
    }

    private void doNotEqualToTest(InstantToObject converter) {
        this.doTest(converter, List.of("!=", "ne"), Boolean.TRUE, Boolean.FALSE, Boolean.TRUE);
    }

    private void doLessThanTest(InstantToObject converter) {
        this.doTest(converter, List.of("<", "lt"), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
    }

    private void doLessThanOrEqualTest(InstantToObject converter) {
        this.doTest(converter, List.of("<=", "le"), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
    }

    private void doGreaterThanOrEqualTest(InstantToObject converter) {
        this.doTest(converter, List.of(">=", "ge"), Boolean.FALSE, Boolean.TRUE, Boolean.TRUE);
    }

    private void doGreaterThanTest(InstantToObject converter) {
        this.doTest(converter, List.of(">", "gt"), Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
    }

    private void doTest(InstantToObject converter, List<String> operators, Boolean beforeResult, Boolean equalResult, Boolean afterResult) {
        for (String operator : operators) {
            this.testOperatorRelational(converter.toObject(TestNum.DATE_REFERENCE_BEFORE), beforeResult, operator);
            this.testOperatorRelational(converter.toObject(TestNum.DATE_REFERENCE), equalResult, operator);
            this.testOperatorRelational(converter.toObject(TestNum.DATE_REFERENCE_AFTER), afterResult, operator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOperatorRelational(Object testValue, Boolean expectedResult, String operator) {
        for (Object testDateTime : this.dateTimeList) {
            NameValuePair[] values = NameValuePair.buildNameValuePair(testValue, testDateTime);
            try {
                String expr = ExprEval.buildElExpr(false, operator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are " + testValue.getClass().getName() + " and " + testDateTime.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                Assertions.assertTrue((boolean)ExprEval.compareClass(result, Boolean.class));
                Assertions.assertEquals((Object)result, (Object)expectedResult);
            }
            finally {
                ExprEval.cleanup();
            }
        }
    }

    @FunctionalInterface
    public static interface InstantToObject {
        public Object toObject(Instant var1);
    }
}

