/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.interceptors.contract.lifecycleCallback.wrapped;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cdi.tck.tests.full.interceptors.contract.lifecycleCallback.wrapped.Bar;
import org.testng.Assert;

@Dependent
public class Bird {
    private static AtomicInteger initBirdCalled = new AtomicInteger();
    private static AtomicInteger destroyBirdCalled = new AtomicInteger();
    protected Bar eagleBar;
    private Bar birdBar;

    @Inject
    private void initBirdBar(Bar bar) {
        this.birdBar = bar;
    }

    @PostConstruct
    public void initBird() {
        Assert.assertNotNull((Object)this.birdBar);
        Assert.assertNotNull((Object)this.eagleBar);
        initBirdCalled.incrementAndGet();
    }

    @PreDestroy
    public void destroyBird() {
        destroyBirdCalled.incrementAndGet();
    }

    public static void reset() {
        initBirdCalled.set(0);
        destroyBirdCalled.set(0);
    }

    public static AtomicInteger getInitBirdCalled() {
        return initBirdCalled;
    }

    public static AtomicInteger getDestroyBirdCalled() {
        return destroyBirdCalled;
    }
}

