/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.controls.internal.fx.Activator;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.view.model.internal.fx.SimpleControlRendererFX;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SingleReferenceRendererFX
extends SimpleControlRendererFX {
    private ReferenceService referenceService;
    private Adapter adapter;

    public void init(VControl control, ViewModelContext viewModelContext) {
        super.init(control, viewModelContext);
        viewModelContext.getService(ReferenceService.class);
    }

    protected Node createControl() {
        final VControl control = (VControl)this.getVElement();
        final HBox hBox = new HBox();
        Hyperlink link = new Hyperlink();
        ImageView linkImage = new ImageView();
        final IObservableValue modelValue = this.getModelObservable((EStructuralFeature.Setting)control.getDomainModelReference().getIterator().next());
        control.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (msg.getFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic()) {
                    SingleReferenceRendererFX.this.applyValidation(control, (Node)hBox);
                }
            }
        });
        IObservableValue targetValue = this.getTargetObservable(link, "text");
        final Binding linkBinding = this.bindModelToTarget(targetValue, modelValue, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return modelValue.getValue();
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return SingleReferenceRendererFX.this.getLinkText(value);
            }
        });
        this.adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (!msg.isTouch()) {
                    linkBinding.updateModelToTarget();
                }
            }
        };
        EObject currentReference = this.getReferencedEObject();
        if (currentReference != null) {
            currentReference.eAdapters().add((Object)this.adapter);
        }
        link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SingleReferenceRendererFX.this.referenceService.openInNewContext((EObject)modelValue.getValue());
            }
        });
        IObservableValue imageTargetValue = this.getTargetObservable(linkImage, "image");
        this.getDataBindingContext().bindValue(imageTargetValue, modelValue, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return modelValue.getValue();
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return SingleReferenceRendererFX.this.getImage(value);
            }
        });
        hBox.getChildren().add((Object)linkImage);
        hBox.getChildren().add((Object)link);
        hBox.getChildren().addAll((Object[])this.createButtons());
        return hBox;
    }

    protected ImageView getImageView(String path) {
        return new ImageView(Activator.getImage(path));
    }

    protected Button[] createButtons() {
        Button deleteRefButton = new Button();
        deleteRefButton.setGraphic((Node)this.getImageView("icons/delete.png"));
        deleteRefButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SingleReferenceRendererFX.this.removeAdapterFromReferencedEObject();
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VControl)SingleReferenceRendererFX.this.getVElement()).getDomainModelReference().getIterator().next();
                EditingDomain ed = SingleReferenceRendererFX.this.getEditingDomain(setting);
                EReference reference = (EReference)setting.getEStructuralFeature();
                Command removeCommand = SetCommand.create((EditingDomain)ed, (Object)setting.getEObject(), (Object)reference, null);
                ed.getCommandStack().execute(removeCommand);
            }
        });
        Button addExistingRefButton = new Button();
        addExistingRefButton.setGraphic((Node)this.getImageView("icons/link_overlay.png"));
        addExistingRefButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SingleReferenceRendererFX.this.removeAdapterFromReferencedEObject();
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VControl)SingleReferenceRendererFX.this.getVElement()).getDomainModelReference().getIterator().next();
                EditingDomain ed = SingleReferenceRendererFX.this.getEditingDomain(setting);
                EReference reference = (EReference)setting.getEStructuralFeature();
                EObject newReference = SingleReferenceRendererFX.this.referenceService.getExistingElementFor(reference);
                if (newReference != null) {
                    Command setCommand = SetCommand.create((EditingDomain)ed, (Object)setting.getEObject(), (Object)reference, (Object)newReference);
                    ed.getCommandStack().execute(setCommand);
                    newReference.eAdapters().add((Object)SingleReferenceRendererFX.this.adapter);
                }
            }
        });
        Button addNewRefButton = new Button();
        addNewRefButton.setGraphic((Node)this.getImageView("icons/add.png"));
        addNewRefButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SingleReferenceRendererFX.this.removeAdapterFromReferencedEObject();
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VControl)SingleReferenceRendererFX.this.getVElement()).getDomainModelReference().getIterator().next();
                EReference reference = (EReference)setting.getEStructuralFeature();
                EObject newElement = SingleReferenceRendererFX.this.referenceService.getNewElementFor(reference);
                if (newElement != null) {
                    SingleReferenceRendererFX.this.referenceService.addModelElement(newElement, reference);
                    newElement.eAdapters().add((Object)SingleReferenceRendererFX.this.adapter);
                }
            }
        });
        Button[] buttons = new Button[]{deleteRefButton, addExistingRefButton, addNewRefButton};
        return buttons;
    }

    protected String getLinkText(Object value) {
        String linkName = this.getAdapterFactoryItemDelegator().getText(value);
        return linkName == null ? "" : linkName;
    }

    protected Image getImage(Object value) {
        if (value == null) {
            return null;
        }
        String urlString = ((URL)this.getAdapterFactoryItemDelegator().getImage(value)).toString();
        return new Image(urlString);
    }

    private EObject getReferencedEObject() {
        return (EObject)EObject.class.cast(((EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next()).get(true));
    }

    private void removeAdapterFromReferencedEObject() {
        EObject currentReference = this.getReferencedEObject();
        if (currentReference != null) {
            currentReference.eAdapters().remove((Object)this.adapter);
        }
    }
}

