/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSTaskObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;

public class CompCSTaskGroup
extends CompCSTaskObject
implements ICompCSTaskGroup {
    private List<ICompCSTaskObject> fFieldTaskObjects;
    private static final long serialVersionUID = 1L;

    public CompCSTaskGroup(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
        this.reset();
    }

    @Override
    public List<ICompCSTaskObject> getChildren() {
        ArrayList<ICompCSTaskObject> list = new ArrayList<ICompCSTaskObject>();
        if (this.fFieldTaskObjects.size() > 0) {
            list.addAll(this.fFieldTaskObjects);
        }
        return list;
    }

    @Override
    public String getName() {
        return this.fFieldName;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void reset() {
        super.reset();
        this.fFieldTaskObjects = new ArrayList<ICompCSTaskObject>();
    }

    @Override
    public void addFieldTaskObject(ICompCSTaskObject taskObject) {
        this.fFieldTaskObjects.add(taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }

    @Override
    public void addFieldTaskObject(int index, ICompCSTaskObject taskObject) {
        if (index < 0) {
            return;
        }
        if (index >= this.fFieldTaskObjects.size()) {
            this.fFieldTaskObjects.add(taskObject);
        } else {
            this.fFieldTaskObjects.add(index, taskObject);
        }
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }

    @Override
    public int getFieldTaskObjectCount() {
        return this.fFieldTaskObjects.size();
    }

    @Override
    public ICompCSTaskObject[] getFieldTaskObjects() {
        return this.fFieldTaskObjects.toArray(new ICompCSTaskObject[this.fFieldTaskObjects.size()]);
    }

    @Override
    public boolean hasFieldTaskObjects() {
        return !this.fFieldTaskObjects.isEmpty();
    }

    @Override
    public int indexOfFieldTaskObject(ICompCSTaskObject taskObject) {
        return this.fFieldTaskObjects.indexOf(taskObject);
    }

    @Override
    public boolean isFirstFieldTaskObject(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        return position == 0;
    }

    @Override
    public boolean isLastFieldTaskObject(ICompCSTaskObject taskObject) {
        int lastPosition;
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        return position == (lastPosition = this.fFieldTaskObjects.size() - 1);
    }

    @Override
    public void removeFieldTaskObject(ICompCSTaskObject taskObject) {
        this.fFieldTaskObjects.remove(taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 2);
        }
    }

    @Override
    public void removeFieldTaskObject(int index) {
        if (index < 0 || index > this.fFieldTaskObjects.size() - 1) {
            return;
        }
        ICompCSTaskObject taskObject = this.fFieldTaskObjects.remove(index);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 2);
        }
    }

    @Override
    protected void parseElement(Element element) {
        super.parseElement(element);
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        if (name.equals("task")) {
            ICompCSTask task = factory.createCompCSTask(this);
            this.fFieldTaskObjects.add(task);
            task.parse(element);
        } else if (name.equals("taskGroup")) {
            ICompCSTaskGroup taskGroup = factory.createCompCSTaskGroup(this);
            this.fFieldTaskObjects.add(taskGroup);
            taskGroup.parse(element);
        }
    }

    @Override
    protected void writeElements(String indent, PrintWriter writer) {
        super.writeElements(indent, writer);
        String newIndent = String.valueOf(indent) + "   ";
        for (ICompCSTaskObject taskObject : this.fFieldTaskObjects) {
            taskObject.write(newIndent, writer);
        }
    }

    @Override
    public String getElement() {
        return "taskGroup";
    }

    @Override
    public ICompCSTaskObject getNextSibling(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        int lastIndex = this.fFieldTaskObjects.size() - 1;
        if (position == -1 || position == lastIndex) {
            return null;
        }
        return this.fFieldTaskObjects.get(position + 1);
    }

    @Override
    public ICompCSTaskObject getPreviousSibling(ICompCSTaskObject taskObject) {
        int position = this.fFieldTaskObjects.indexOf(taskObject);
        if (position == -1 || position == 0) {
            return null;
        }
        return this.fFieldTaskObjects.get(position - 1);
    }

    @Override
    public void moveFieldTaskObject(ICompCSTaskObject taskObject, int newRelativeIndex) {
        int currentIndex = this.indexOfFieldTaskObject(taskObject);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= this.fFieldTaskObjects.size()) {
            return;
        }
        this.fFieldTaskObjects.remove(taskObject);
        this.fFieldTaskObjects.add(newIndex, taskObject);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)taskObject, 1);
        }
    }
}

