/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.SimpleName;

public final class SemanticToken {
    private SimpleName fNode;
    private Expression fLiteral;
    private IBinding fBinding;
    private boolean fIsBindingResolved = false;
    private CompilationUnit fRoot;
    private boolean fIsRootResolved = false;

    public IBinding getBinding() {
        if (!this.fIsBindingResolved) {
            this.fIsBindingResolved = true;
            if (this.fNode != null) {
                this.fBinding = this.fNode.resolveBinding();
            }
        }
        return this.fBinding;
    }

    public SimpleName getNode() {
        return this.fNode;
    }

    public Expression getLiteral() {
        return this.fLiteral;
    }

    public CompilationUnit getRoot() {
        if (!this.fIsRootResolved) {
            this.fIsRootResolved = true;
            this.fRoot = (CompilationUnit)(this.fNode != null ? this.fNode : this.fLiteral).getRoot();
        }
        return this.fRoot;
    }

    public void update(SimpleName node) {
        this.clear();
        this.fNode = node;
    }

    public void update(Expression literal) {
        this.clear();
        this.fLiteral = literal;
    }

    public void clear() {
        this.fNode = null;
        this.fLiteral = null;
        this.fBinding = null;
        this.fIsBindingResolved = false;
        this.fRoot = null;
        this.fIsRootResolved = false;
    }
}

