/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eclipse.utils.Diagram;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import net.sourceforge.plantuml.eclipse.views.DiagramImageControl;
import net.sourceforge.plantuml.eclipse.views.actions.DiagramImageAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;

public class ExportAction
extends DiagramImageAction {
    public ExportAction(DiagramImageControl control, Diagram diagram) {
        super(control, diagram);
        this.setText("Export");
    }

    public void run() {
        FileDialog fDialog = new FileDialog(this.getControl().getShell(), 8192);
        fDialog.setFilterExtensions(new String[]{"*.png", "*.svg", "*.jpg", "*.gif"});
        fDialog.open();
        String fileName = fDialog.getFileName();
        if (StringUtils.isNotEmpty((String)fileName)) {
            String filePathName = String.valueOf(fDialog.getFilterPath()) + System.getProperty("file.separator") + fileName;
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
            if ("svg".equals(ext)) {
                this.createImageFileSvg(filePathName, this.diagram.getTextDiagram());
            } else {
                this.createImageFile(filePathName, ext, this.getImage());
            }
        }
    }

    private void createImageFile(String fileName, String format, ImageData imageData) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        try {
            int swtFormat = SWT.class.getField("IMAGE_" + format.toUpperCase()).getInt(null);
            loader.save(fileName, swtFormat);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createImageFileSvg(String filePathName, String textDiagram) {
        block12: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(filePathName);
                    SourceStringReader reader = new SourceStringReader(textDiagram);
                    reader.outputImage((OutputStream)fos, new FileFormatOption(FileFormat.SVG));
                }
                catch (IOException e) {
                    WorkbenchUtil.errorBox("Error during file generation for export.");
                    if (fos == null) break block12;
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        WorkbenchUtil.errorBox("Error during file generation.");
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        WorkbenchUtil.errorBox("Error during file generation.");
                    }
                }
            }
        }
    }
}

