/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.util.Properties;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.parser.ResultParser;
import org.xml.sax.Attributes;

public class ContextParser
extends ResultParser {
    private ParseElement element = null;
    private String currentTag;

    public ContextParser() {
        super("title");
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        this.currentTag = name;
        if (name.equalsIgnoreCase("description")) {
            return;
        }
        Properties properties = new Properties();
        properties.put("tagName", name);
        int i = 0;
        while (i < attrs.getLength()) {
            String qname = attrs.getQName(i);
            String val = attrs.getValue(i);
            properties.put(qname, val);
            ++i;
        }
        ParseElement elem = new ParseElement(properties, this.element);
        if (this.element != null) {
            this.element.addChild(elem);
        } else {
            this.items.add(elem);
        }
        this.element = elem;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Properties properties;
        if (this.element != null && this.currentTag.equalsIgnoreCase("description") && (properties = this.element.getProps()) != null) {
            String content = new String(ch, start, length);
            String existing = (String)properties.get(this.currentTag);
            if (existing == null) {
                existing = "";
            }
            content = content.replaceAll("[\\n\\t]", "").trim();
            properties.put(this.currentTag, String.valueOf(existing) + content);
            this.element.updateParseElement(properties);
        }
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        if (name.equalsIgnoreCase("description")) {
            return;
        }
        if (this.element != null) {
            this.element = this.element.getParent();
        }
    }
}

