/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.RemoveElementsFromGroup;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class AddElementsToGroup
extends Command
implements ScopedCommand {
    private final Group targetGroup;
    private final List<FBNetworkElement> elementsToAdd;
    private final CompoundCommand removeFromOtherGroups = new CompoundCommand();
    private final Position offset;

    public AddElementsToGroup(Group targetGroup, List<?> selection, Point offset) {
        this.targetGroup = Objects.requireNonNull(targetGroup);
        this.offset = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(offset.x, offset.y);
        this.elementsToAdd = AddElementsToGroup.createElementList(selection);
        this.identifyRemoveElements();
    }

    private void identifyRemoveElements() {
        HashMap<Group, List> groupMap = new HashMap<Group, List>();
        this.elementsToAdd.stream().filter(FBNetworkElement::isInGroup).forEach(el -> {
            List entry = groupMap.computeIfAbsent(el.getGroup(), group -> new ArrayList());
            entry.add(el);
        });
        groupMap.forEach((group, list) -> this.removeFromOtherGroups.add((Command)new RemoveElementsFromGroup((Collection<FBNetworkElement>)list)));
    }

    public List<FBNetworkElement> getElementsToAdd() {
        return this.elementsToAdd;
    }

    public boolean canExecute() {
        return !this.elementsToAdd.isEmpty() && this.noGroupsContained() && this.targetIsInSameFbNetwork();
    }

    private boolean noGroupsContained() {
        return this.elementsToAdd.stream().noneMatch(Group.class::isInstance);
    }

    public void execute() {
        this.removeFromOtherGroups.execute();
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToAdd, (double)(-this.offset.getX()), (double)(-this.offset.getY()));
        this.addElementsToGroup();
        FBNetworkHelper.selectElements(this.elementsToAdd);
    }

    public void redo() {
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToAdd, (double)(-this.offset.getX()), (double)(-this.offset.getY()));
        this.addElementsToGroup();
    }

    public void undo() {
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToAdd, (double)this.offset.getX(), (double)this.offset.getY());
        this.removeElementsFromGroup();
        this.removeFromOtherGroups.undo();
    }

    private void addElementsToGroup() {
        this.elementsToAdd.forEach(el -> {
            boolean bl = this.targetGroup.getGroupElements().add(el);
        });
    }

    private void removeElementsFromGroup() {
        this.elementsToAdd.forEach(el -> {
            boolean bl = this.targetGroup.getGroupElements().remove(el);
        });
    }

    private boolean targetIsInSameFbNetwork() {
        FBNetwork fbNetwork = this.targetGroup.getFbNetwork();
        return this.elementsToAdd.stream().allMatch(el -> fbNetwork.equals(el.getFbNetwork()) || el.getFbNetwork() == null);
    }

    private static List<FBNetworkElement> createElementList(List<?> selection) {
        ArrayList<FBNetworkElement> elements = new ArrayList<FBNetworkElement>();
        for (Object fbNetworkElement : selection) {
            if (fbNetworkElement instanceof EditPart) {
                EditPart ep = (EditPart)fbNetworkElement;
                fbNetworkElement = ep.getModel();
            }
            if (!(fbNetworkElement instanceof FBNetworkElement)) continue;
            FBNetworkElement fbnEl = (FBNetworkElement)fbNetworkElement;
            elements.add(fbnEl);
        }
        return elements;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.targetGroup);
    }
}

