/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElement;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;

public class TargetPinManager {
    private final Map<IInterfaceElement, TargetInterfaceElement> targetPinChildren = new HashMap<IInterfaceElement, TargetInterfaceElement>();
    private final InterfaceEditPart host;

    public TargetPinManager(InterfaceEditPart host) {
        this.host = host;
    }

    List<TargetInterfaceElement> getModelChildren(boolean isOverflow) {
        List<IInterfaceElement> pins = this.host.isInput() ? this.getSourcePins() : this.getTargetPins();
        this.targetPinChildren.keySet().removeIf(key -> !pins.contains(key));
        FBNetwork parentNW = this.getModel().getBlockFBNetworkElement().getFbNetwork();
        pins.forEach(pin -> {
            TargetInterfaceElement targetInterfaceElement = this.targetPinChildren.computeIfAbsent((IInterfaceElement)pin, newEntry -> TargetInterfaceElement.createFor(this.getModel(), newEntry, parentNW));
        });
        if (isOverflow) {
            List<TargetInterfaceElement> grouped = pins.stream().filter(ie -> TargetPinManager.getContainer(ie) != null).collect(Collectors.groupingBy(TargetPinManager::getContainer)).entrySet().stream().map(e -> {
                if (((List)e.getValue()).size() == 1) {
                    return TargetInterfaceElement.createFor(this.getModel(), (IInterfaceElement)((List)e.getValue()).get(0), parentNW);
                }
                return new TargetInterfaceElement.GroupTargetInterfaceElement(this.getModel(), (List)e.getValue(), (SubApp)e.getKey());
            }).collect(Collectors.toList());
            List<TargetInterfaceElement> normal = this.targetPinChildren.values().stream().filter(target -> TargetPinManager.getContainer(target.getRefElement()) == null).toList();
            grouped.addAll(normal);
            return grouped;
        }
        return this.targetPinChildren.values().stream().sorted().toList();
    }

    private IInterfaceElement getModel() {
        return this.host.getModel();
    }

    private List<IInterfaceElement> getTargetPins() {
        return this.getModel().getOutputConnections().stream().filter(con -> !con.isVisible() && con.getDestination() != null).flatMap(TargetPinManager::getTargetPins).filter(Objects::nonNull).toList();
    }

    private static Stream<IInterfaceElement> getTargetPins(Connection con) {
        IInterfaceElement destination = con.getDestination();
        if (destination != null && TargetPinManager.followConnections((FBNetworkElement)destination.getBlockFBNetworkElement(), (EList<Connection>)destination.getOutputConnections())) {
            return destination.getOutputConnections().stream().flatMap(TargetPinManager::getTargetPins);
        }
        return Stream.of(destination);
    }

    private List<IInterfaceElement> getSourcePins() {
        return this.getModel().getInputConnections().stream().filter(con -> !con.isVisible() && con.getSource() != null).flatMap(TargetPinManager::getSourcePins).filter(Objects::nonNull).toList();
    }

    private static Stream<IInterfaceElement> getSourcePins(Connection con) {
        IInterfaceElement source = con.getSource();
        if (source != null && TargetPinManager.followConnections((FBNetworkElement)source.getBlockFBNetworkElement(), (EList<Connection>)source.getInputConnections())) {
            return source.getInputConnections().stream().flatMap(TargetPinManager::getSourcePins);
        }
        return Stream.of(source);
    }

    static boolean followConnections(FBNetworkElement fbnEl, EList<Connection> conList) {
        UntypedSubApp subapp;
        return fbnEl instanceof UntypedSubApp && !TargetPinManager.isContainedInUnfoldedSubapp(subapp = (UntypedSubApp)fbnEl) && !conList.isEmpty();
    }

    private static boolean isContainedInUnfoldedSubapp(UntypedSubApp subapp) {
        SubApp outerSubApp;
        FBNetworkElement fBNetworkElement = subapp.getOuterFBNetworkElement();
        return fBNetworkElement instanceof SubApp && (outerSubApp = (SubApp)fBNetworkElement).isUnfolded();
    }

    private static SubApp getContainer(IInterfaceElement ie) {
        BlockFBNetworkElement blockFBNetworkElement = ie.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof FB) {
            FB fb = (FB)blockFBNetworkElement;
            SubApp container = FBNetworkElementHelper.getContainerSubappOfFB((FB)fb);
            if (container != null) {
                return container.isUnfolded() ? container : null;
            }
            return null;
        }
        BlockFBNetworkElement blockFBNetworkElement2 = ie.getBlockFBNetworkElement();
        if (blockFBNetworkElement2 instanceof SubApp) {
            SubApp subapp = (SubApp)blockFBNetworkElement2;
            return subapp.isUnfolded() ? subapp : null;
        }
        return null;
    }
}

